/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.tag;

import com.n2bb.util.N2bbSettings;
import com.n2bb.util.ScrollUtil;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScrollTag
extends TagSupport {
    private Log n2bbLog = LogFactory.getLog((String)"n2bbLog");
    private int recStart;
    private int size;
    private String styleClass;
    private String formName;
    private String action;

    public void setRecStart(int recStart) {
        this.recStart = recStart;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public int doStartTag() throws JspTagException {
        try {
            this.n2bbLog.debug((Object)"enter");
            int pageSize = N2bbSettings.PAGE_SIZE;
            this.n2bbLog.debug((Object)("recStart (requested)... " + this.recStart));
            this.recStart = ScrollUtil.getStartRecord(this.recStart, pageSize, this.size);
            this.n2bbLog.debug((Object)("recStart (final)... " + this.recStart));
            int currentPage = this.recStart / pageSize + 1;
            this.n2bbLog.debug((Object)("currentPage... " + currentPage));
            int totalPages = this.size / pageSize;
            if (this.size % pageSize > 0) {
                ++totalPages;
            }
            this.n2bbLog.debug((Object)("totalPages... " + totalPages));
            int next = this.recStart + pageSize;
            if (next > this.size) {
                next = -1;
            }
            this.n2bbLog.debug((Object)("next... " + next));
            int prev = this.recStart - pageSize;
            if (prev < 1) {
                prev = -1;
            }
            this.n2bbLog.debug((Object)("prev... " + prev));
            StringBuffer scroll = new StringBuffer("\n<script language=\"javascript\">\n");
            scroll.append("function scrollPage(newRecStart) {\n");
            scroll.append("  document." + this.formName + ".action.value=\"" + this.action + "\";\n");
            scroll.append("  document." + this.formName + ".recStart.value=newRecStart;\n");
            scroll.append("  document." + this.formName + ".submit();\n");
            scroll.append("}\n");
            scroll.append("function gotoPage() {\n");
            scroll.append("  if (document." + this.formName + ".gotoPage.value == \"\")\n");
            scroll.append("    alert(\"Please enter a page number.\");\n");
            scroll.append("  else {\n");
            scroll.append("    document." + this.formName + ".action.value=\"" + this.action + "\";\n");
            scroll.append("    document." + this.formName + ".submit();\n");
            scroll.append("  }\n");
            scroll.append("}\n");
            scroll.append("</script>\n");
            scroll.append("<input type=\"hidden\" name=\"recStart\">\n");
            scroll.append("\n<td");
            if (this.styleClass != null && !this.styleClass.trim().equals("")) {
                scroll.append(" class=\"" + this.styleClass + "\"");
            }
            scroll.append(">");
            scroll.append("Page: " + currentPage + " of " + totalPages);
            scroll.append("<img src=\"/images/icn_arrow_left.gif\">");
            if (prev < 0) {
                scroll.append(" prev ");
            } else {
                scroll.append("<a href=\"javascript:scrollPage(" + prev + ");\"> prev </a>");
            }
            scroll.append(" | ");
            if (next < 0) {
                scroll.append(" next ");
            } else {
                scroll.append("<a href=\"javascript:scrollPage(" + next + ");\"> next </a>");
            }
            scroll.append("<img src=\"/images/icn_arrow_right.gif\">");
            scroll.append(" <a href=\"javascript:gotoPage();\">goto:</a> ");
            scroll.append(" <input type=\"text\" name=\"gotoPage\" size=\"4\" value=\"\"/>");
            scroll.append("</td>");
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            JspWriter out = this.pageContext.getOut();
            out.write(scroll.toString());
        }
        catch (Exception e) {
            throw new JspTagException("ScrollTag.doStartTag exception - message... " + e.getMessage());
        }
        return 0;
    }
}

