/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.user;

import com.n2bb.util.N2bbEmail;
import com.n2bb.util.N2bbException;
import com.n2bb.util.N2bbUtility;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public final class UserForm
extends ActionForm {
    private Log n2bbLog = LogFactory.getLog((String)"n2bbLog");
    private String actionType = "add";
    private String userName = null;
    private boolean changePassword = false;
    private String password = null;
    private String confirmPassword = null;
    private String firstName = null;
    private String lastName = null;
    private String roleName = null;
    private String status = null;
    private String email = null;
    private String phoneArea = null;
    private String phoneFirst = null;
    private String phoneLast = null;
    private String extn = null;
    private String employeeId = null;
    private String department = null;
    private String location = null;

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.userName = null;
        this.changePassword = false;
        this.password = null;
        this.confirmPassword = null;
        this.firstName = null;
        this.lastName = null;
        this.roleName = null;
        this.email = null;
        this.phoneArea = null;
        this.phoneFirst = null;
        this.phoneLast = null;
        this.extn = null;
        this.status = null;
        this.employeeId = null;
        this.department = null;
        this.location = null;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        try {
            String phone;
            if (this.getFirstName().equals("")) {
                errors.add("firstName", new ActionError("error.user.firstNameRequired"));
            }
            if (this.getFirstName().length() > 60) {
                errors.add("firstName", new ActionError("error.user.firstNameTooLong"));
            }
            if (this.getLastName().equals("")) {
                errors.add("lastName", new ActionError("error.user.lastNameRequired"));
            }
            if (this.getLastName().length() > 60) {
                errors.add("lastName", new ActionError("error.user.lastNameTooLong"));
            }
            if (this.getUserName().equals("")) {
                errors.add("userName", new ActionError("error.user.userNameRequired"));
            }
            if (!N2bbUtility.isLoginName(this.getUserName())) {
                errors.add("userName", new ActionError("error.user.userNameInvalid"));
            }
            if (this.getUserName().length() < 3 || this.getUserName().length() > 96) {
                errors.add("userName", new ActionError("error.user.userNameLength"));
            }
            if (this.getRoleName().equals("")) {
                errors.add("roleName", new ActionError("error.user.roleNameRequired"));
            }
            if (this.getChangePassword()) {
                if (this.getPassword().equals("")) {
                    errors.add("password", new ActionError("error.user.passwordRequired"));
                }
                if (this.getPassword().length() < 6 || this.getPassword().length() > 16) {
                    errors.add("password", new ActionError("error.user.passwordLength"));
                }
                if (this.getPassword().equals(this.getUserName())) {
                    errors.add("password", new ActionError("error.user.passwordUserName"));
                }
                if (this.getConfirmPassword().equals("")) {
                    errors.add("confirmPassword", new ActionError("error.user.confirmPasswordRequired"));
                }
                if (!this.getPassword().equals(this.getConfirmPassword())) {
                    errors.add("confirmPassword", new ActionError("error.user.confirmPasswordPassword"));
                }
            }
            if (this.getEmail().equals("")) {
                errors.add("email", new ActionError("error.user.emailRequired"));
            } else {
                this.n2bbLog.debug((Object)("email... '" + this.getEmail() + "'"));
                try {
                    N2bbEmail email = new N2bbEmail(this.getEmail());
                }
                catch (N2bbException e) {
                    this.n2bbLog.debug((Object)("email n2bb exception - message... " + e.getMessage()));
                    errors.add("email", new ActionError(e.getErrorCode()));
                }
                catch (Exception e) {
                    this.n2bbLog.error((Object)("email exception - message... " + e.getMessage()), (Throwable)e);
                    errors.add("email", new ActionError("error.email.validationFailed"));
                }
            }
            if (this.getEmployeeId().equals("")) {
                errors.add("employeeId", new ActionError("error.user.employeeIdRequired"));
            }
            if (this.getEmployeeId().length() > 50) {
                errors.add("employeeId", new ActionError("error.user.employeeIdTooLong"));
            }
            if (this.getDepartment().equals("")) {
                errors.add("department", new ActionError("error.user.departmentRequired"));
            }
            if (this.getDepartment().length() > 50) {
                errors.add("department", new ActionError("error.user.departmentTooLong"));
            }
            if (this.getLocation().equals("")) {
                errors.add("location", new ActionError("error.user.locationRequired"));
            }
            if (this.getLocation().length() > 50) {
                errors.add("location", new ActionError("error.user.locationTooLong"));
            }
            if (!(phone = (this.getPhoneArea() + this.getPhoneFirst() + this.getPhoneLast()).trim()).equals("")) {
                if (!N2bbUtility.isDigits(phone)) {
                    errors.add("phone", new ActionError("error.user.phoneInvalid"));
                }
                if (phone.length() < 10) {
                    errors.add("phone", new ActionError("error.user.phoneTooShort"));
                }
            }
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other.validation"));
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
        }
        return errors;
    }

    public boolean isAdminUser() {
        return this.userName != null && this.userName.equalsIgnoreCase("admin");
    }

    public boolean isEdit() {
        return this.actionType != null && (this.actionType.equals("edit") || this.actionType.equals("update"));
    }

    public String getSubmitAction() {
        return this.isEdit() ? "update" : "save";
    }

    public String getSaveRole() {
        return this.isEdit() ? "Modify Roles" : "Create Roles";
    }

    public String getUserName() {
        return this.userName == null ? "" : this.userName;
    }

    public boolean getChangePassword() {
        return this.changePassword;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword == null ? "" : this.confirmPassword;
    }

    public String getFirstName() {
        return this.firstName == null ? "" : this.firstName.trim();
    }

    public String getLastName() {
        return this.lastName == null ? "" : this.lastName.trim();
    }

    public String getRoleName() {
        return this.roleName == null ? "" : this.roleName.trim();
    }

    public String getStatus() {
        return this.status == null ? "" : this.status.trim();
    }

    public String getEmail() {
        return this.email == null ? "" : this.email.trim();
    }

    public String getPhoneArea() {
        return this.phoneArea == null ? "" : this.phoneArea.trim();
    }

    public String getPhoneFirst() {
        return this.phoneFirst == null ? "" : this.phoneFirst.trim();
    }

    public String getPhoneLast() {
        return this.phoneLast == null ? "" : this.phoneLast.trim();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName.trim();
    }

    public void setLastName(String lastName) {
        this.lastName = lastName.trim();
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhoneArea(String phoneArea) {
        this.phoneArea = phoneArea;
    }

    public void setPhoneFirst(String phoneFirst) {
        this.phoneFirst = phoneFirst;
    }

    public void setPhoneLast(String phoneLast) {
        this.phoneLast = phoneLast;
    }

    public String getDepartment() {
        return this.department == null ? "" : this.department.trim();
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getEmployeeId() {
        return this.employeeId == null ? "" : this.employeeId.trim();
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getExtn() {
        return this.extn == null ? "" : this.extn.trim();
    }

    public void setExtn(String extn) {
        this.extn = extn;
    }

    public String getLocation() {
        return this.location == null ? "" : this.location.trim();
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

