/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.user;

import com.n2bb.security.SecurityManager;
import com.n2bb.security.UserSecurityData;
import com.n2bb.user.UserBean;
import com.n2bb.util.DigestUtil;
import com.n2bb.util.N2bbException;
import com.n2bb.util.PropertyManager;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager {
    private static final Logger n2bbLog = Logger.getLogger(UserManager.class);
    private static final String SEAT_LICENSE = "seatLicense";
    private static UserManager instance;

    private UserManager() {
    }

    public static synchronized UserManager getInstance() {
        if (instance == null) {
            instance = new UserManager();
        }
        return instance;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listUsers() throws N2bbException {
        n2bbLog.debug((Object)"enter");
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Vector<UserBean> usersVector = new Vector<UserBean>();
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            stmt = con.createStatement();
            String query = "Select * from user_data";
            rs = stmt.executeQuery(query);
            while (true) {
                if (!rs.next()) {
                    n2bbLog.debug((Object)("users found... " + usersVector.size()));
                    this.closeStatement(stmt);
                    this.closeConnection(con);
                    return usersVector;
                }
                UserBean bean = new UserBean();
                bean.setUserName(rs.getString(1));
                bean.setFirstName(rs.getString(2));
                bean.setLastName(rs.getString(3));
                bean.setEmail(rs.getString(4));
                bean.setPhone(rs.getString(5));
                try {
                    UserSecurityData securityData = SecurityManager.getInstance().getUserSecurityData(bean.getUserName());
                    bean.setStatus(securityData.getStatus());
                    bean.setRoleName(securityData.getRole());
                }
                catch (N2bbException e) {
                    n2bbLog.error((Object)("failed to retrieve user framework data... " + bean.getUserName()), (Throwable)e);
                    bean.setStatus("undetermined");
                    bean.setRoleName("undetermined");
                }
                usersVector.add(bean);
            }
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    private DataSource getDataSource() {
        return PropertyManager.getUIDataSource();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveUser(UserBean bean) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + bean.getUserName()));
        if (!this.seatLicenseAvailable()) {
            throw new N2bbException("error.userManager.noAvailableLicense");
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            if (SecurityManager.getInstance().userExists(bean.getUserName())) {
                n2bbLog.warn((Object)("user already exists... " + bean.getUserName()));
                throw new N2bbException("error.userManager.duplicateUserName");
            }
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            try {
                con.setAutoCommit(false);
                n2bbLog.debug((Object)("getPassword... " + bean.getPassword()));
                SecurityManager.getInstance().createUser(bean.getUserName(), bean.getPassword(), bean.getStatus(), bean.getRoleName(), con);
                pstmt = con.prepareStatement("insert into USER_DATA (USER_NAME,FIRSTNAME,LASTNAME,EMAIL,PHONE,EMPLOYEEID,DEPARTMENT,LOCATION,EXTENSION) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                pstmt.setString(1, bean.getUserName());
                pstmt.setString(2, bean.getFirstName());
                pstmt.setString(3, bean.getLastName());
                pstmt.setString(4, bean.getEmail());
                pstmt.setString(5, bean.getPhone());
                pstmt.setString(6, bean.getEmployeeId());
                pstmt.setString(7, bean.getDepartment());
                pstmt.setString(8, bean.getLocation());
                pstmt.setString(9, bean.getExtn());
                pstmt.executeUpdate();
                pstmt.close();
                con.commit();
                con.setAutoCommit(true);
            }
            catch (N2bbException e) {
                con.rollback();
                con.setAutoCommit(true);
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                con.rollback();
                con.setAutoCommit(true);
                throw new N2bbException("error.other");
            }
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return;
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    private boolean seatLicenseAvailable() throws N2bbException {
        int numOfActiveUsers = this.getNumOfActiveUsers();
        int numOfSeatLicenses = 0;
        try {
            numOfSeatLicenses = this.getNumOfSeatLicenses();
        }
        catch (InvalidLicenseException e1) {
            throw new N2bbException("error.userManager.cannotReadLicense");
        }
        return numOfActiveUsers < numOfSeatLicenses;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteUser(String name) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            try {
                con.setAutoCommit(false);
                pstmt = con.prepareStatement("delete from user_data where user_name = ?");
                pstmt.setString(1, name);
                pstmt.executeUpdate();
                pstmt.close();
                SecurityManager.getInstance().deleteUser(name, con);
                con.commit();
                con.setAutoCommit(true);
            }
            catch (N2bbException e) {
                con.rollback();
                con.setAutoCommit(true);
                throw e;
            }
            catch (Exception e) {
                n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                con.rollback();
                con.setAutoCommit(true);
                throw new N2bbException("error.other");
            }
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return;
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserBean getUser(String name) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + name));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        UserBean bean = new UserBean();
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            String query = "select USER_NAME,FIRSTNAME,LASTNAME,EMAIL,PHONE,EMPLOYEEID,DEPARTMENT,LOCATION,EXTENSION from user_data where user_name=?";
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                bean.setUserName(rs.getString("USER_NAME"));
                bean.setFirstName(rs.getString("FIRSTNAME"));
                bean.setLastName(rs.getString("LASTNAME"));
                bean.setEmail(rs.getString("EMAIL"));
                bean.setPhone(rs.getString("PHONE"));
                bean.setEmployeeId(rs.getString("EMPLOYEEID"));
                bean.setDepartment(rs.getString("DEPARTMENT"));
                bean.setLocation(rs.getString("LOCATION"));
                bean.setExtn(rs.getString("EXTENSION"));
                UserSecurityData securityData = SecurityManager.getInstance().getUserSecurityData(name);
                bean.setStatus(securityData.getStatus());
                bean.setRoleName(securityData.getRole());
            } else {
                n2bbLog.debug((Object)"user not found");
            }
            UserBean userBean = bean;
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return userBean;
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateUser(UserBean bean, boolean changePassword) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + bean.getUserName()));
        n2bbLog.debug((Object)("change password... " + changePassword));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            block19: {
                con = this.getDataSource().getConnection();
                if (con == null) {
                    throw new N2bbException("error.userManager.databaseNoConnection");
                }
                pstmt = con.prepareStatement("select status from users_realm where USER_NAME=?");
                pstmt.setString(1, bean.getUserName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ResourceManagement resourceManagement;
                    Resource resource;
                    int status = rs.getInt(1);
                    if (status == 0 && (bean.getStatus().equalsIgnoreCase("Active") || bean.getStatus().equalsIgnoreCase("A"))) {
                        if (!this.seatLicenseAvailable()) {
                            throw new N2bbException("error.userManager.noAvailableLicense");
                        }
                    } else if (status == 1 && bean.getStatus().equalsIgnoreCase("I") && (resource = (resourceManagement = ResourceManager.getInstance()).getResourceByUser(bean.getUserName())) != null) {
                        if (resource.getAdministrationState() != ResourceState.OFFLINE) throw new N2bbException("error.userManager.unChangedUser");
                        if (resource.getOperationalState() != ResourceState.INVALID && resource.getOperationalState() != ResourceState.INACTIVE && resource.getOperationalState() != ResourceState.OFFLINE) {
                            throw new N2bbException("error.userManager.unChangedUser");
                        }
                    }
                }
                try {
                    con.setAutoCommit(false);
                    int iStatus = 0;
                    if (bean.getStatus().equalsIgnoreCase("Active") || bean.getStatus().equalsIgnoreCase("A")) {
                        iStatus = 1;
                    }
                    if (changePassword) {
                        pstmt = con.prepareStatement("update USERS_REALM set USER_PASS=?,PASSWORD_MODIFIED_DATE=sysdate,STATUS=?,UPDATEDATE=sysdate where USER_NAME=?");
                        pstmt.setString(1, DigestUtil.Digest(bean.getPassword(), "SHA"));
                        pstmt.setInt(2, iStatus);
                        pstmt.setString(3, bean.getUserName());
                    } else {
                        pstmt = con.prepareStatement("UPDATE USERS_REALM SET STATUS=?,UPDATEDATE=SYSDATE WHERE USER_NAME=?");
                        pstmt.setInt(1, iStatus);
                        pstmt.setString(2, bean.getUserName());
                    }
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = con.prepareStatement("UPDATE USER_BIGROLE SET BIGROLE=?,UPDATEDATE=SYSDATE WHERE USER_NAME=?");
                    pstmt.setString(1, bean.getRoleName());
                    pstmt.setString(2, bean.getUserName());
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = con.prepareStatement("UPDATE USER_DATA SET FIRSTNAME=?,LASTNAME=?,EMAIL=?,PHONE=?,UPDATEDATE=SYSDATE,EMPLOYEEID=?,DEPARTMENT=?,LOCATION=?,EXTENSION=? WHERE USER_NAME=?");
                    pstmt.setString(1, bean.getFirstName());
                    pstmt.setString(2, bean.getLastName());
                    pstmt.setString(3, bean.getEmail());
                    pstmt.setString(4, bean.getPhone());
                    pstmt.setString(5, bean.getEmployeeId());
                    pstmt.setString(6, bean.getDepartment());
                    pstmt.setString(7, bean.getLocation());
                    pstmt.setString(8, bean.getExtn());
                    pstmt.setString(9, bean.getUserName());
                    pstmt.executeUpdate();
                    pstmt.close();
                    con.commit();
                    con.setAutoCommit(true);
                }
                catch (Exception e) {
                    n2bbLog.error((Object)e.getMessage(), (Throwable)e);
                    con.rollback();
                    con.setAutoCommit(true);
                    if (e instanceof N2bbException) {
                        n2bbLog.error((Object)("n2bb exception - message... " + e.getMessage()), (Throwable)e);
                        throw (N2bbException)e;
                    }
                    if (!(e instanceof SQLException)) break block19;
                    n2bbLog.error((Object)("SQLException - message... " + e.getMessage()), (Throwable)e);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
            }
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return;
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    private void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getNumOfActiveUsers() throws N2bbException {
        int result = 0;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query;
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            stmt = con.createStatement();
            rs = stmt.executeQuery(query = "select count(*) from USERS_REALM where STATUS=1");
            if (rs.next()) {
                result = rs.getInt(1);
                n2bbLog.debug((Object)("number of active users = " + result));
            } else {
                n2bbLog.debug((Object)"users not found");
                result = 0;
            }
            int n = result;
            this.closeStatement(stmt);
            this.closeConnection(con);
            return n;
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    private int getNumOfSeatLicenses() throws InvalidLicenseException {
        int result = -1;
        LicenseManager licManager = LicenseManager.getInstance();
        String seatLicense = licManager.getObject(SEAT_LICENSE);
        n2bbLog.debug((Object)("String value for seatLicense: " + seatLicense));
        if (seatLicense == null || seatLicense.trim().length() == 0) {
            return Integer.MAX_VALUE;
        }
        result = Integer.parseInt(seatLicense.trim());
        if (result < 0) {
            throw new InvalidLicenseException("Invalid License for seatLicense - non-negative value must be specified");
        }
        return result;
    }

    public void init() throws InvalidLicenseException, N2bbException {
        int numOfSeatLicenses = this.getNumOfSeatLicenses();
        int numOfActiveUsers = Integer.MAX_VALUE;
        n2bbLog.debug((Object)("numOfSeatLicenses=" + numOfSeatLicenses));
        n2bbLog.debug((Object)("numOfActiveUsers=" + numOfActiveUsers));
        if (numOfActiveUsers <= numOfSeatLicenses) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeSomeActiveUsersInactive(int numOfSeatLicenses) throws N2bbException {
        Connection con = null;
        Statement stmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> inactiveUserNames = new ArrayList<String>();
        try {
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            stmt = con.createStatement();
            String query = "Select user_name from users_realm where STATUS=1 order by CREATEDATE";
            rs = stmt.executeQuery(query);
            int activeUserCount = 0;
            while (rs.next()) {
                String userName = rs.getString(1);
                if (activeUserCount >= numOfSeatLicenses) {
                    inactiveUserNames.add(userName);
                    n2bbLog.debug((Object)("added to inactiveList: " + userName));
                }
                ++activeUserCount;
            }
            con.setAutoCommit(false);
            int iStatus = 0;
            Iterator i$ = inactiveUserNames.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    con.commit();
                    con.setAutoCommit(true);
                    this.closeStatement(stmt);
                    this.closeConnection(con);
                    return;
                }
                String userName = (String)i$.next();
                prepStmt = con.prepareStatement("UPDATE USERS_REALM SET STATUS=?,UPDATEDATE=SYSDATE WHERE USER_NAME=?");
                prepStmt.setInt(1, iStatus);
                prepStmt.setString(2, userName);
                prepStmt.executeUpdate();
                prepStmt.close();
            }
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toggleUserStatus(String userName) throws N2bbException {
        n2bbLog.debug((Object)("enter user... " + userName));
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int status;
            con = this.getDataSource().getConnection();
            if (con == null) {
                throw new N2bbException("error.userManager.databaseNoConnection");
            }
            pstmt = con.prepareStatement("select status from users_realm where USER_NAME=?");
            pstmt.setString(1, userName);
            rs = pstmt.executeQuery();
            if (rs.next() && (status = rs.getInt(1)) == 0 && !this.seatLicenseAvailable()) {
                n2bbLog.info((Object)"throwing n2bbexception - no avail license");
                throw new N2bbException("error.userManager.noAvailableLicense");
            }
            SecurityManager.getInstance().toggleUserStatus(userName);
            this.closeStatement(pstmt);
            this.closeConnection(con);
            return;
        }
        catch (N2bbException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    n2bbLog.error((Object)("SQLException - message... " + e2.getMessage()), (Throwable)e2);
                    throw new N2bbException("error.userManager.databaseAccessError");
                }
                catch (Exception e3) {
                    n2bbLog.error((Object)e3.getMessage(), (Throwable)e3);
                    throw new N2bbException("error.other");
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public List<String> getInactiveUserNames() throws N2bbException {
        return new ArrayList<String>();
    }
}

