/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListFilterUtil {
    private static final Log log = LogFactory.getLog((String)"n2bbLog");

    public static List wildcardFilter(List list, Class listClass, String propertyName, String wildcard) {
        ArrayList filteredList = new ArrayList();
        String regex = wildcard.replaceAll("\\*", ".*").replaceAll("\\?", ".");
        Method method = ListFilterUtil.getMethod(listClass, propertyName);
        if (method != null) {
            Pattern p2 = Pattern.compile(regex, 2);
            Matcher m2 = p2.matcher("");
            for (Object listElement : list) {
                String propertyValue = (String)ListFilterUtil.getPropertyValue(method, listElement);
                m2.reset(propertyValue);
                if (!m2.matches()) continue;
                filteredList.add(listElement);
            }
        }
        return filteredList;
    }

    private static Method getMethod(Class methodClass, String propertyName) {
        try {
            String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            return methodClass.getMethod(methodName, null);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private static Object getPropertyValue(Method method, Object listElement) {
        try {
            return method.invoke(listElement, null);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"", (Throwable)e);
        }
        return null;
    }
}

