/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyManager {
    public static final String UI_DATA_SOURCE = "java:/uiDataSource";
    private static Log log = LogFactory.getLog(PropertyManager.class);
    private static PropertyManager instance;
    public static final String PROPERTIES_TABLE = "UI_PROPERTIES";
    public static final String VALUE_COLUMN = "VALUE";
    public static final String NAME_COLUMN = "NAME";
    public static final String PASSWORD_LIFE_PROPERTY = "PASSWORD_LIFE";
    public static final String SESSION_TIMEOUT_PROPERTY = "SESSION_TIMEOUT";
    public static final String PAGE_SIZE_PROPERTY = "PAGE_SIZE";
    public static final String SITE_LOCATION_PROPERTY = "SITE_LOCATION";
    public static final String SHOW_USER_PROPERTY = "SHOW_USER";
    public static final String SHOW_DATE_PROPERTY = "SHOW_DATE";
    public static final int DEFAULT_PASSWORD_LIFE = 0;
    public static final int DEFAULT_SESSION_TIMEOUT = 30;
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final String DEFAULT_SITE_LOCATION = "Default Site Name";
    public static final String DEFAULT_SHOW_USER = "true";
    public static final String DEFAULT_SHOW_DATE = "true";
    private static DataSource dataSource;

    private PropertyManager() {
    }

    public static synchronized DataSource getUIDataSource() {
        if (dataSource == null) {
            try {
                InitialContext envContext = new InitialContext();
                dataSource = (DataSource)envContext.lookup(UI_DATA_SOURCE);
            }
            catch (NamingException e) {
                log.warn((Object)"Unable to find data source using JNDI", (Throwable)e);
                return null;
            }
        }
        return dataSource;
    }

    public static synchronized PropertyManager getInstance() {
        if (instance == null) {
            instance = new PropertyManager();
        }
        return instance;
    }

    public int getInteger(String name, int defaultValue) {
        Integer value = null;
        try {
            value = this.getInteger(name);
        }
        catch (NumberFormatException ex) {
            log.error((Object)("Value for property " + name + " is not a parseable integer"));
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Integer getInteger(String name) throws NumberFormatException {
        String value = this.getValue(name);
        if (value != null) {
            return new Integer(value);
        }
        return null;
    }

    public String getValue(String name, String defaultValue) {
        String value = this.getValue(name);
        if (value == null || value.trim().equals("")) {
            return defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String name) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = PropertyManager.getUIDataSource().getConnection();
            ps = conn.prepareStatement("select VALUE from  UI_PROPERTIES where NAME = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                this.closeStatement(ps);
                this.closeConnection(conn);
                return string;
            }
            this.closeStatement(ps);
            this.closeConnection(conn);
        }
        catch (Exception ex) {
            try {
                log.error((Object)("Error getting value for property with name = " + name), (Throwable)ex);
                this.closeStatement(ps);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String name, String value) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = PropertyManager.getUIDataSource().getConnection();
            ps = conn.prepareStatement("delete  from  UI_PROPERTIES where NAME = ?");
            ps.setString(1, name);
            ps.executeUpdate();
            ps = conn.prepareStatement("insert into UI_PROPERTIES values (?, ?)");
            ps.setString(1, name);
            ps.setString(2, value);
            int count = ps.executeUpdate();
            if (count != 1) {
                log.error((Object)("Unable to set value for property with name = " + name));
            }
            this.closeStatement(ps);
            this.closeConnection(conn);
        }
        catch (SQLException ex) {
            try {
                log.error((Object)("Unable to set value for property with name = " + name), (Throwable)ex);
                this.closeStatement(ps);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    private void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

