/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.web.util;

import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppPopup {
    private static final String POPUP_NAME = "system links";
    private static Log n2bbLog = LogFactory.getLog(AppPopup.class);

    public static String buildPopup(ServletContext servletContext, String popupDir) {
        try {
            String popup = AppPopup.getPopupStart();
            Set popupPaths = servletContext.getResourcePaths(popupDir);
            for (String path : popupPaths) {
                if (!path.endsWith(".xml")) continue;
                popup = popup + AppPopup.getPopupItems(servletContext, path);
            }
            return popup + "\n</div>\n";
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return POPUP_NAME;
        }
    }

    private static String getPopupItems(ServletContext servletContext, String path) {
        try {
            InputStream is = servletContext.getResourceAsStream(path);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            Document doc = domBuilder.parse(is);
            return AppPopup.getPopupItems(doc);
        }
        catch (Exception e) {
            n2bbLog.error((Object)"", (Throwable)e);
            return "";
        }
    }

    private static String getPopupStart() {
        return "<a href=\"javascript:void(0)\" onClick=\"javascript:showPop(event)\" target=\"_top\">system links</a>\n<div id=\"apps\" class=\"appswitcher-hide\" onMouseOver=\"holdPop=true\" onMouseOut=\"holdPop=false;showPop()\">\n";
    }

    private static String getPopupItems(Document doc) {
        Node appPopupNode = doc.getFirstChild();
        NodeList list = appPopupNode.getChildNodes();
        String popup = "";
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals("menuItem")) continue;
            String display = ((Element)node).getAttribute("display");
            String path = ((Element)node).getAttribute("path");
            if (display == null || display.trim().equals("") || path == null || path.trim().equals("")) continue;
            popup = popup + "<a href=\"" + path + "\" onMouseOver=\"holdPop=true\" target=\"_top\" " + "class=\"appswitcher-link\">" + display + "</a><br>";
        }
        return popup;
    }
}

