/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.web.util;

import com.n2bb.util.SortCriteria;
import com.n2bb.web.util.DashItem;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Dashboard {
    private static Log n2bbLog = LogFactory.getLog(Dashboard.class);

    public static String buildDash(ServletContext servletContext, String dashDir) {
        try {
            LinkedList dashItems = new LinkedList();
            Set dashPaths = servletContext.getResourcePaths(dashDir);
            for (String path : dashPaths) {
                if (!path.endsWith(".xml")) continue;
                Dashboard.addDashItemsToList(servletContext, path, dashItems);
            }
            n2bbLog.info((Object)("dashboard items... " + dashItems.size()));
            if (dashItems.size() < 1) {
                return "";
            }
            StringBuffer dash = new StringBuffer("<table class=\"module\">\n");
            dash.append(Dashboard.getDashItems(dashItems));
            dash.append("</table>");
            return dash.toString();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return "<table><tr><td>init error</td></tr></table>";
        }
    }

    private static void addDashItemsToList(ServletContext servletContext, String path, List dashItems) {
        try {
            InputStream is = servletContext.getResourceAsStream(path);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            Document doc = domBuilder.parse(is);
            Node appPopupNode = doc.getFirstChild();
            NodeList list = appPopupNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getNodeName().equals("dashItem")) continue;
                Element el = (Element)node;
                dashItems.add(new DashItem(el.getAttribute("display"), el.getAttribute("path"), el.getAttribute("img"), el.getAttribute("newWin"), el.getAttribute("priority")));
                n2bbLog.info((Object)("added dashboard item... " + el.getAttribute("display")));
            }
        }
        catch (Exception e) {
            n2bbLog.error((Object)("error processing... " + path + " - message... " + e.getMessage()), (Throwable)e);
        }
    }

    private static String getDashItems(List dashItems) {
        SortCriteria sort = new SortCriteria();
        sort.setPrimaryMethodCriteria("getPriority");
        sort.setSecondaryMethodCriteria("getDisplay");
        Collections.sort(dashItems, sort);
        StringBuffer sb = new StringBuffer();
        int itemCnt = 0;
        sb.append("  <tr>\n");
        for (DashItem di : dashItems) {
            sb.append("    <td>\n");
            sb.append("      <a href=\"").append(di.path).append("\"><img\n");
            sb.append("      border=\"0\" height=\"50\" width=\"50\" title=\"").append(di.display).append("\"\n");
            sb.append("      src=\"").append(di.img).append("\"></a><br/>\n");
            sb.append("      <a href=\"").append(di.path).append("\">").append(di.display).append("</a>\n");
            sb.append("    </td>\n");
            if (itemCnt++ < 3) continue;
            sb.append("  </tr>\n");
            sb.append("  <tr>\n");
            itemCnt = 0;
        }
        sb.append("  </tr>\n");
        return sb.toString();
    }
}

