/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor;

import com.tandbergtv.workflow.adaptor.AbstractDefaultAdaptor;
import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorRegistryImpl;
import com.tandbergtv.workflow.adaptor.DefaultAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRegistry;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.ConfigurationLoaderFactory;
import com.tandbergtv.workflow.adaptor.conf.IConfigurationLoader;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.PluginConfigurationLoader;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.pluginmanager.entities.AdaptorDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptorManager
implements IColleague {
    IAdaptorRegistry adaptorRegistry = new AdaptorRegistryImpl();
    IConfigurationLoader configurationLoader;
    private static AdaptorManager instance;
    private static final Logger logger;

    private AdaptorManager() {
    }

    public static synchronized AdaptorManager getInstance() {
        if (instance == null) {
            instance = new AdaptorManager();
        }
        return instance;
    }

    public void initialize() throws AdaptorException {
        this.configurationLoader = ConfigurationLoaderFactory.newInstance().createStrategy();
        AdaptorConfigurationImpl conf = new AdaptorConfigurationImpl();
        DefaultAdaptor adaptor = new DefaultAdaptor();
        adaptor.init(conf);
        this.adaptorRegistry.setDefaultAdaptor(adaptor);
        this.loadPlugins();
        logger.info((Object)"Adaptor Manager Initialized successfully.");
    }

    public void destroy() {
        DefaultMediator.getInstance().unregister(this);
        logger.info((Object)"Adaptor Manager destroyed.");
    }

    @Override
    public String getColleagueName() {
        return this.getClass().getName();
    }

    @Override
    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    @Override
    public void receive(WorkflowEvent event) {
    }

    public IAdaptor getAdaptor(String className) {
        return this.adaptorRegistry.getAdaptor(className);
    }

    public IAdaptor getAdaptor(IAdaptorRequest request) {
        for (IAdaptor adaptor : this.getRegisteredAdaptors()) {
            try {
                if (!adaptor.canDeliver(request)) continue;
                return adaptor;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        logger.debug((Object)"Returning default adaptor");
        return this.getDefaultAdaptor();
    }

    private void registerAdaptor(String className, ClassLoader classLoader, Map<String, String> properties) throws AdaptorException {
        logger.debug((Object)("Registering adaptor:" + className));
        try {
            Class<?> idClass = classLoader.loadClass(className);
            this.adaptorRegistry.registerAdaptor(className, (IAdaptor)idClass.newInstance());
            this.adaptorRegistry.getAdaptor(className).init(new AdaptorConfigurationImpl(properties));
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Adaptor class " + className + " not found.", e);
        }
        catch (InstantiationException e) {
            throw new AdaptorException("Error instantiating an object of adaptor class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new AdaptorException("Error instantiating an object of adaptor " + className, e);
        }
    }

    public Iterable<IAdaptor> getRegisteredAdaptors() {
        return this.adaptorRegistry.getRegisteredAdaptors();
    }

    public AbstractDefaultAdaptor getDefaultAdaptor() {
        return this.adaptorRegistry.getDefaultAdaptor();
    }

    private void addConfigurationToDefaultAdaptor(IMessageUID uid, IMessageProcessorConfiguration conf) {
        logger.debug((Object)("Adding config for uid:" + uid));
        this.getDefaultAdaptor().addConfiguration(uid, conf);
    }

    private void loadPlugins() {
        logger.debug((Object)"loading plugins...");
        List<ResourceTypeDescriptor> descriptors = WatchPointPluginManager.getInstance().getResourceTypeDescriptors();
        PluginConfigurationLoader confLoader = new PluginConfigurationLoader();
        logger.debug((Object)("descriptor count:" + descriptors.size()));
        for (ResourceTypeDescriptor descriptor : descriptors) {
            logger.debug((Object)("Descriptor : " + descriptor.getName()));
            AdaptorDescriptor adaptorDesc = descriptor.getAdaptor();
            if (adaptorDesc == null) continue;
            if (adaptorDesc.isDefault()) {
                if (adaptorDesc.getMessageIdentifierClass() != null && !adaptorDesc.getMessageIdentifierClass().equals("")) {
                    try {
                        logger.debug((Object)("Adding message identifier class " + adaptorDesc.getMessageIdentifierClass()));
                        this.addMessageIdentifierClass(adaptorDesc.getMessageIdentifierClass(), descriptor.getClassLoader());
                    }
                    catch (AdaptorException e) {
                        logger.error((Object)("Error adding message identifier class " + adaptorDesc.getMessageIdentifierClass()), (Throwable)e);
                    }
                }
                Map<String, MessageDescriptor> messages = descriptor.getMessages();
                for (String key : messages.keySet()) {
                    MessageDescriptor messageDesciptor = messages.get(key);
                    MessageUIDImpl uid = new MessageUIDImpl(messageDesciptor.getUID());
                    IMessageProcessorConfiguration conf = confLoader.getConfiguration(descriptor.getClassLoader(), uid);
                    logger.debug((Object)("Adding configuration for UID " + uid));
                    this.addConfigurationToDefaultAdaptor(uid, conf);
                }
                continue;
            }
            try {
                this.registerAdaptor(adaptorDesc.getAdaptorClass(), descriptor.getClassLoader(), adaptorDesc.getProperties());
            }
            catch (AdaptorException e) {
                logger.error((Object)("Error registering adaptor class " + adaptorDesc.getAdaptorClass()), (Throwable)e);
            }
        }
    }

    private void addMessageIdentifierClass(String className, ClassLoader classLoader) throws AdaptorException {
        try {
            Class<?> idClass = classLoader.loadClass(className);
            this.getDefaultAdaptor().addMessageIDClass((IMessageIdentifier)idClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Message identifier class " + className + " not found.", e);
        }
        catch (InstantiationException e) {
            throw new AdaptorException("Error instantiating an object of message identifier class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new AdaptorException("Error instantiating an object of message identifier class " + className, e);
        }
    }

    static {
        logger = Logger.getLogger(AdaptorManager.class);
    }
}

