/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor;

import com.tandbergtv.workflow.adaptor.AdaptorRequestFactoryException;
import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class AdaptorRequestFactory {
    private static final Logger logger = Logger.getLogger(AdaptorRequestFactory.class);

    private AdaptorRequestFactory() {
    }

    public static AdaptorRequestFactory newInstance() {
        return new AdaptorRequestFactory();
    }

    public IAdaptorRequest createRequest(SOAPMessage message) {
        return new AdaptorRequestImpl(this.convertSOAPMessage(message));
    }

    private IMessage convertSOAPMessage(SOAPMessage message) {
        String encoding = XMLUtils.getEncoding((Message)((Message)message), (MessageContext)MessageContext.getCurrentContext());
        String host = ((ServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getRemoteHost();
        logger.info((Object)("Request from " + host));
        MessageImpl msg = null;
        try {
            SOAPBody body = message.getSOAPBody();
            Iterator iterator = body.getChildElements();
            if (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                logger.debug((Object)("Element name is: " + element.getNodeName()));
                IPayload payload = this.getPayload(element, encoding);
                logger.debug((Object)("Payload is: " + payload));
                HTTPAttachment attachment = this.getAttachment(message);
                msg = new MessageImpl(payload, attachment);
            }
        }
        catch (Exception e) {
            throw new AdaptorRequestFactoryException("Failed to create message", e);
        }
        return msg;
    }

    private HTTPAttachment getAttachment(SOAPMessage message) throws SOAPException {
        int count = message.countAttachments();
        logger.debug((Object)("Message contains " + count + " attachment(s)"));
        Iterator i = message.getAttachments();
        if (i.hasNext()) {
            AttachmentPart part = (AttachmentPart)i.next();
            logger.info((Object)("Attachment content-type is " + part.getContentType()));
            return new HTTPAttachment(part.getContent(), part.getContentType());
        }
        return null;
    }

    private IPayload getPayload(Element root, String encoding) throws Exception {
        return new StringPayload(XMLDocumentUtility.convertToString(root, encoding));
    }
}

