/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.tandbergtv.workflow.adaptor.conf.DispatcherParameter;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.StringReader;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class SOAPDispatcher
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(SOAPDispatcher.class);

    public SOAPDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage msg) throws DispatcherException {
        HTTPMessage responseMessage = null;
        try {
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            if (msg.getAttachment() != null) {
                Object attachContent = msg.getAttachment().getContent();
                String attachType = msg.getAttachment().getContentType();
                message.addAttachmentPart(message.createAttachmentPart(attachContent, attachType));
            }
            MimeHeaders headers = message.getMimeHeaders();
            String soapAction = this.getConfiguration().getParameterValue(DispatcherParameter.SOAP_ACTION);
            soapAction = soapAction == null ? "" : soapAction;
            headers.addHeader("SOAPAction", soapAction);
            SOAPPart soapPart = message.getSOAPPart();
            String msgContent = msg.getPayload().getContent();
            soapPart.setContent((Source)new StreamSource(new StringReader(msgContent)));
            SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
            String url = ((HTTPDevice)this.getDestination()).getUrl();
            logger.debug((Object)("Making SOAP call to " + url));
            SOAPMessage reply = connection.call(message, (Object)url);
            SOAPBody body = reply.getSOAPBody();
            if (body.getFault() != null) {
                SOAPFault fault = body.getFault();
                logger.warn((Object)fault.getFaultString());
            }
            String response = XMLDocumentUtility.convertToString((Node)reply.getSOAPPart());
            responseMessage = new HTTPMessage(new HTTPPayload(response));
            logger.debug((Object)("responsemessage: " + responseMessage));
            connection.close();
        }
        catch (SOAPException ex) {
            throw new DispatcherException("Could not send SOAP message.", ex);
        }
        catch (Exception ex) {
            throw new DispatcherException("Could not send xml from SOAP responce message.", ex);
        }
        return responseMessage;
    }
}

