/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.DurationAware;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.logging.log.ProcessLog;

public class NodeGroup
extends SuperState
implements DurationAware,
ResourceGroupAware {
    private static final long serialVersionUID = 1214915925481664560L;
    private Long resourceGroupID;
    private String duration;
    private String taskDuration;
    private static final Long DEFAULT_RESOURCE_GROUP_ID = -1L;
    private static final Logger logger = Logger.getLogger(NodeGroup.class);

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public Long getResourceGroupID() {
        if (this.resourceGroupID.equals(DEFAULT_RESOURCE_GROUP_ID)) {
            return null;
        }
        return this.resourceGroupID;
    }

    public void setResourceGroupID(Long resourceGroupID) {
        this.resourceGroupID = resourceGroupID == null ? DEFAULT_RESOURCE_GROUP_ID : resourceGroupID;
    }

    public String getTaskDuration() {
        return this.taskDuration;
    }

    public void setTaskDuration(String taskDuration) {
        this.taskDuration = taskDuration;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        this.action = jpdlReader.readSingleAction(element);
        this.setDuration(element.attributeValue("duration"));
        this.setTaskDuration(element.attributeValue("taskDuration"));
        super.read(element, jpdlReader);
    }

    public void enter(ExecutionContext context) {
        logger.info((Object)(context.getToken() + " (" + this.name + ")"));
        this.fireEvent("superstate-enter", context);
        CustomToken token = (CustomToken)context.getToken();
        token.setSuperStateEnter(new Date());
        this.execute(context);
    }

    public void execute(ExecutionContext executionContext) {
        if (this.nodes == null || this.nodes.size() == 0) {
            throw new JbpmException("Transition enters superstate '" + this + "' and there is no first child-node to delegate to.");
        }
        Node startNode = this.first();
        logger.debug((Object)("First Node of super-state " + this + " is " + startNode.getName()));
        if (startNode == null) {
            throw new JbpmException("Super state '" + this + "' does not have an entry node (any node with an incoming transition from outside the super-state).");
        }
        startNode.enter(executionContext);
    }

    public void leave(ExecutionContext context) {
        logger.info((Object)(context.getToken() + " (" + this.name + ")"));
        this.fireEvent("superstate-leave", context);
        CustomToken token = (CustomToken)context.getToken();
        if (token.getSuperStateEnter() != null) {
            token.addLog((ProcessLog)new NodeLog((Node)this, token.getSuperStateEnter(), new Date()));
        }
    }

    public Node first() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            for (Object transObj : node.getArrivingTransitions()) {
                Transition transition = (Transition)transObj;
                if (transition.getFrom().getSuperState() != null && transition.getFrom().getSuperState().equals((Object)this)) continue;
                return node;
            }
        }
        return null;
    }

    public Node last() {
        return (Node)this.nodes.get(this.nodes.size() - 1);
    }
}

