/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Exec
extends ProcessState {
    private static final long serialVersionUID = -5608286665493465148L;
    private static final Logger logger = Logger.getLogger(Exec.class);

    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        logger.info((Object)(token + " (" + this.name + ")"));
        WorkflowProcess child = (WorkflowProcess)token.createSubProcessInstance(this.subProcessDefinition);
        ContextInstance contextInstance = context.getContextInstance();
        ContextInstance subContextInstance = child.getContextInstance();
        subContextInstance.setTransientVariables(contextInstance.getTransientVariables());
        for (VariableAccess variable : this.variableAccesses) {
            if (!variable.isReadable()) continue;
            Object value = contextInstance.getVariable(variable.getVariableName(), (Token)token);
            subContextInstance.setVariable(variable.getMappedName(), value);
        }
        child.signal();
    }

    public void leave(ExecutionContext context, Transition transition) {
        WorkflowProcess child = (WorkflowProcess)context.getSubProcessInstance();
        CustomToken token = (CustomToken)child.getSuperProcessToken();
        logger.info((Object)(token + " (" + this.name + ")"));
        ContextInstance contextInstance = context.getContextInstance();
        ContextInstance subContextInstance = child.getContextInstance();
        for (VariableAccess variable : this.variableAccesses) {
            if (!variable.isWritable()) continue;
            Object value = subContextInstance.getVariable(variable.getMappedName());
            contextInstance.setVariable(variable.getVariableName(), value, (Token)token);
        }
        super.leave(context, this.getDefaultLeavingTransition());
    }

    public void read(Element element, JpdlXmlReader reader) {
        Object resolver = null;
        Element e = element.element("sub-process");
        this.subProcessDefinition = resolver.findSubProcess(e);
        this.variableAccesses = new HashSet(reader.readVariableAccesses(element));
    }
}

