/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSInterpreter;
import com.tandbergtv.workflow.util.DurationUtility;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class While
extends AbstractTaskNode {
    private String expression;
    private static final long serialVersionUID = 6323412180232943515L;
    private static final Logger logger = Logger.getLogger(While.class);

    public While() {
    }

    public While(String name) {
        super(name);
    }

    public String getExpression() {
        return this.expression;
    }

    public void execute(ExecutionContext context) {
        boolean leave = false;
        CustomToken token = (CustomToken)context.getToken();
        long millis = this.getSleepDelay(context);
        while (!leave) {
            try {
                ActionHandler handler = (ActionHandler)this.action.getActionDelegation().instantiate();
                handler.execute(context);
                Object result = JbpmExpressionEvaluator.evaluate((String)this.expression, (ExecutionContext)context);
                logger.info((Object)(token + " expression result is " + result));
                Thread.sleep(millis);
                leave = Boolean.valueOf(result.toString());
            }
            catch (Throwable t) {
                logger.error((Object)(token + ", execution has failed"), t);
                token.fail();
                break;
            }
        }
        if (token.getStatus() != ProcessStatus.ERROR) {
            this.leave(context);
        }
    }

    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        super.read(nodeElement, jpdlXmlReader);
        this.expression = nodeElement.attributeValue("expression");
    }

    protected long getSleepDelay(ExecutionContext context) {
        long millis = 1000L;
        try {
            millis = new DurationUtility().getDurationInMillis(this.getDuration(), new WFSInterpreter(context));
        }
        catch (Exception e) {
            logger.error((Object)(context.getToken() + " failed to calculate sleep delay"), (Throwable)e);
        }
        if (millis < 1000L) {
            millis = 1000L;
        }
        return millis;
    }
}

