/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing;

import com.tandbergtv.workflow.core.licensing.ILicenseReader;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseKey;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.encryption.EncryptionUtil;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileLicenseReader
implements ILicenseReader {
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";
    private static Logger logger = Logger.getLogger(FileLicenseReader.class);

    private String getConfigPath() throws InvalidLicenseException {
        String configPath = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            configPath = properties.getProperty("WorkflowApp.ConfigPath");
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Problems getting WorkflowApp.ConfigPath from application.properties file", e);
        }
        if (configPath == null || configPath.trim().length() == 0) {
            throw new InvalidLicenseException("WorkflowApp.ConfigPath not specified in application.properties file");
        }
        return configPath;
    }

    public LicenseKey getLicense(String password) throws InvalidLicenseException {
        String encrLicenseFilePath = this.getConfigPath().trim() + File.separator + ENCRYPTED_FILE_NAME;
        LicenseKey licenseKey = new LicenseKey();
        EncryptionUtil encUtil = new EncryptionUtil();
        InputStream cis = encUtil.getEncryptedInputStream(password, encrLicenseFilePath);
        HashMap<String, String> licenseMap = new HashMap<String, String>();
        Properties prop = new Properties();
        try {
            prop.loadFromXML(cis);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Could not read properties from the encrypted input stream", e);
        }
        for (String param : LicenseKeyConstants.licenseParams) {
            String value = prop.getProperty(param);
            licenseMap.put(param, value);
            logger.debug((Object)(param + "-" + value));
        }
        licenseKey.setLicenseMap(licenseMap);
        return licenseKey;
    }
}

