/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.dao;

import com.tandbergtv.workflow.dao.HibernateContextException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public final class HibernateContext {
    private static Logger log = Logger.getLogger(HibernateContext.class);
    private static final String HIBERNATE_CONFIG_RESOURCE = "/com/tandbergtv/workflow/dao/hibernate.cfg.xml";
    private static HibernateContext context = new HibernateContext();
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private boolean active = false;

    private HibernateContext() {
    }

    private void initialize() {
        if (this.active) {
            log.info((Object)"The Hibernate Context is already initialized, skipping initialization.");
            return;
        }
        log.debug((Object)"Initializing the Hibernate Context...");
        try {
            this.initializeConfiguration();
            this.initializeSessionFactory();
        }
        catch (HibernateContextException hce) {
            throw hce;
        }
        catch (Exception ex) {
            String msg = "Failed to load the Hibernate Context";
            throw new HibernateContextException(msg, ex);
        }
        this.active = true;
        log.info((Object)"Successfully initialized the Hibernate Context.");
    }

    private void initializeConfiguration() {
        log.debug((Object)"Loading the Hibernate Configuration...");
        this.configuration = new Configuration();
        this.configuration.configure(HIBERNATE_CONFIG_RESOURCE);
        log.debug((Object)"Successfully loaded the Hibernate Configuration.");
    }

    private void initializeSessionFactory() {
        log.debug((Object)"Creating the Session Factory to use...");
        SessionFactory factory = null;
        String factoryName = this.configuration.getProperty("hibernate.session_factory_name");
        if (factoryName != null) {
            log.debug((Object)("Looking up configured SessionFactory in JNDI: " + factoryName));
            try {
                Object factoryObject = new InitialContext().lookup(factoryName);
                factoryObject = PortableRemoteObject.narrow((Object)factoryObject, SessionFactory.class);
                factory = (SessionFactory)factoryObject;
            }
            catch (NamingException ne) {
                String msg = "Failed to lookup specified Session Factory in JNDI: " + factoryName;
                throw new HibernateContextException(msg, ne);
            }
            catch (ClassCastException cce) {
                String msg = "Failed to cast the configured SessionFactory in JNDI to a SessionFactory: " + factoryName;
                throw new HibernateContextException(msg, cce);
            }
            catch (Exception ex) {
                String msg = "Failed to build the configured SessionFactory in JNDI: " + factoryName;
                throw new HibernateContextException(msg, ex);
            }
        } else {
            factory = this.configuration.buildSessionFactory();
        }
        this.sessionFactory = factory;
        log.debug((Object)"Successfully created the Session Factory.");
    }

    public static synchronized HibernateContext getContext() {
        if (context == null) {
            context = new HibernateContext();
        }
        return context;
    }

    public synchronized Configuration getConfiguration() {
        if (!this.active) {
            String msg = "The Hibernate Context is not initialized, cannot get the Configuration.";
            throw new IllegalStateException(msg);
        }
        return this.configuration;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (!this.active) {
            String msg = "The Hibernate Context is not initialized, cannot get the SessionFactory.";
            throw new IllegalStateException(msg);
        }
        return this.sessionFactory;
    }

    public Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    public Session openSession() {
        return this.getSessionFactory().openSession();
    }

    public synchronized void initializeContext() {
        this.initialize();
    }

    public synchronized void closeContext() {
        if (!this.active) {
            log.info((Object)"The Hibernate Context is already closed.");
            return;
        }
        log.debug((Object)"Closing the Hibernate Context...");
        try {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
            }
        }
        catch (Exception ex) {
            String msg = "Failed to close the Hibernate Context.";
            throw new HibernateContextException(msg, ex);
        }
        finally {
            this.sessionFactory = null;
            this.configuration = null;
            this.active = false;
        }
        log.info((Object)"Successfully closed the Hibernate Context.");
    }
}

