/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.ProductInfo;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class EngineDriverProperties
extends Properties {
    private static final long serialVersionUID = 1991050875737707033L;
    private static final String DRIVER_PROPERTIES_FILE = "engineDriver.properties";
    public static String DRIVER_HALTED_PROPERTY = "isDriverHalted";
    private static String COMMENTS = "EngineDriver Properties";
    private static final Lock lock = new ReentrantLock();
    private static EngineDriverProperties instance;
    private static final Logger logger;
    private File driverPropertiesFile = null;

    private EngineDriverProperties() {
        String configPath = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            configPath = properties.getProperty("WorkflowApp.ConfigPath");
            if (configPath != null) {
                configPath = configPath.trim();
            }
        }
        catch (IOException ioe) {
            String msg = "Cannot store: engineDriver.properties, failed to read the Application Properties and read value for key: WorkflowApp.ConfigPath";
            logger.error((Object)msg, (Throwable)ioe);
        }
        if (configPath != null && configPath.length() > 0) {
            String filePath = configPath + File.separator + DRIVER_PROPERTIES_FILE;
            this.driverPropertiesFile = new File(filePath);
            logger.debug((Object)("The Driver Properties File: " + this.driverPropertiesFile.getAbsolutePath()));
            if (!this.driverPropertiesFile.exists()) {
                try {
                    this.save();
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to write properties to the Engine Driver Properties file: " + this.getPropertiesFilePath()), (Throwable)ex);
                }
            } else {
                try {
                    this.load();
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to read any existing Engine Driver Properties file: " + this.getPropertiesFilePath() + ", using default property values."), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineDriverProperties getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new EngineDriverProperties();
            }
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(this.driverPropertiesFile);
            this.load(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to close the Engine Driver Properties File Stream.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.driverPropertiesFile);
            String comments = COMMENTS + " - " + ProductInfo.getInstance().getVersionedProductName();
            this.store(out, comments);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to close the Engine Driver Properties File Stream.", (Throwable)ex);
                }
            }
        }
    }

    private String getPropertiesFilePath() {
        return this.driverPropertiesFile != null ? this.driverPropertiesFile.getAbsolutePath() : null;
    }

    static {
        logger = Logger.getLogger(EngineDriverProperties.class);
    }
}

