/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.plugin;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.plugin.ICreateDelegate;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.TemplateParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.taskmgmt.def.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateProcessChecker
implements ICreateDelegate {
    private static final String WARN_MESSAGE = "Workorder with same parameters already created in the past from template ";
    private static final Logger logger = Logger.getLogger(DuplicateProcessChecker.class);

    @Override
    public void create(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        StringBuilder buf = new StringBuilder(WARN_MESSAGE);
        SearchCriteria criteria = new SearchCriteria();
        String name = template.getName();
        buf.append(name);
        criteria.addParameter(new ValueParameter("processDefinition.name", SearchType.STRING, name));
        String className = template.getClass().getName();
        criteria.addParameter(new TemplateParameter(className));
        List<String> keys = this.getCompositeKeys(template);
        if (keys.size() > 0) {
            buf.append(" with parameters ");
            for (String key : keys) {
                String value = parameters.get(key).toString();
                criteria.addParameter(new ValueParameter(key, SearchType.STRING, true, value));
                buf.append(key).append("=").append(value).append(" ");
            }
            logger.debug((Object)("Checking for duplicates of template " + name));
            if (ServiceRegistry.getDefault().lookup(IProcessSearchService.class).count(criteria) > 0) {
                logger.warn((Object)buf.toString());
            }
        }
    }

    private List<String> getCompositeKeys(ProcessDefinition template) {
        ArrayList<String> keys = new ArrayList<String>();
        Task startTask = template.getTaskMgmtDefinition().getStartTask();
        for (TaskVariable variable : startTask.getTaskController().getVariableAccesses()) {
            if (!variable.isWOKey()) continue;
            logger.debug((Object)("Work Order Key variable found: " + variable.getVariableName()));
            keys.add(variable.getVariableName());
        }
        return keys;
    }
}

