/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.OrParameterMap;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.util.SortingOrder;
import org.apache.log4j.Logger;

public abstract class SearchParameterBase {
    protected static final Logger logger = Logger.getLogger(SearchParameterBase.class);
    private static final String VALUE_PROPERTY = "value";
    protected static final String PROCESS_ALIAS = "process";
    protected static final String WORKFLOW_TEMPLATE_ALIAS = "template";
    protected static final String TOKEN_ALIAS = "token";
    protected static final String RESOURCEUSER_ALIAS = "resourceuser";
    protected static final String RESOURCE_ALIAS = "resource";
    protected String fieldName = null;
    protected SearchType fieldType = null;
    protected boolean varInstance;
    protected String alias = null;
    protected int objectCount;
    protected SortingOrder sortingOrder;
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    protected SearchParameterBase(String name) {
        this(name, SearchType.STRING);
    }

    protected SearchParameterBase(String name, SearchType fieldType) {
        this(name, fieldType, false);
    }

    protected SearchParameterBase(String name, SearchType fieldType, boolean varInstance) {
        this.fieldName = name;
        this.fieldType = fieldType;
        this.varInstance = varInstance;
    }

    public boolean isVarInstance() {
        return this.varInstance;
    }

    public void setVarInstance(boolean varInstance) {
        this.varInstance = varInstance;
    }

    public SearchType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(SearchType fieldType) {
        this.fieldType = fieldType;
    }

    String getAlias() {
        return this.alias;
    }

    void setAlias(String alias) {
        this.alias = alias;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SortingOrder getSortingOrder() {
        return this.sortingOrder;
    }

    public void setSortingOrder(SortingOrder sortingOrder) {
        this.sortingOrder = sortingOrder;
    }

    String getPartialFromClause(int count) {
        this.objectCount = count;
        String fromClause = "";
        if (this.isVarInstance()) {
            String varType = this.getVariableInstanceType();
            this.alias = varType.toLowerCase() + this.objectCount;
            fromClause = this instanceof SortParameter ? " Left Outer Join process.variables " + this.alias + " With " + this.alias + ".name = '" + this.fieldName + "' AND " + this.alias + ".tokenVariableMap is not null" + " AND " + this.alias + ".classType='" + this.getVariableClassType() + "'" : varType + " " + this.alias;
        } else if (this.fieldName.equals("resourceGroup")) {
            this.alias = RESOURCEUSER_ALIAS + this.objectCount;
            fromClause = CustomToken.class.getName() + " " + TOKEN_ALIAS + this.objectCount + "," + ResourceUser.class.getName() + " " + this.alias;
        } else if (this.fieldName.equals("tokenstatus")) {
            fromClause = CustomToken.class.getName() + " " + TOKEN_ALIAS + this.objectCount;
        } else {
            this.alias = PROCESS_ALIAS;
        }
        return fromClause;
    }

    protected String getVariableInstanceType() {
        if (!this.isVarInstance()) {
            logger.error((Object)"Invalid search parameter, cannot return variableInstanceType for non-variableInstances.");
            return null;
        }
        return this.getVarInstanceTypeFromSearchType();
    }

    private String getVarInstanceTypeFromSearchType() {
        switch (this.fieldType) {
            case STRING: {
                return "StringInstance";
            }
            case NUMERIC: {
                return "LongInstance";
            }
            case DATE: {
                return "DateInstance";
            }
        }
        return null;
    }

    private String getVariableClassType() {
        switch (this.fieldType) {
            case STRING: {
                return "S";
            }
            case NUMERIC: {
                return "O";
            }
            case DATE: {
                return "D";
            }
        }
        return null;
    }

    public String getSortingColumn() {
        if (this.sortingOrder == null) {
            throw new RuntimeException("Invalid attempt at getting sorting column for not sorting paramter " + this.fieldName + ".");
        }
        if (!this.isVarInstance()) {
            return this.fieldName;
        }
        if (!(this instanceof SortParameter)) {
            return VALUE_PROPERTY;
        }
        switch (this.fieldType) {
            case STRING: {
                return "stringVal";
            }
            case NUMERIC: {
                return "doubleVal";
            }
            case DATE: {
                return "dateVal";
            }
        }
        return null;
    }

    public String getPartialWhereClause() {
        String whereClause = "";
        if (this instanceof OrParameterMap) {
            return this.getPredicate();
        }
        if (this.isVarInstance() && !(this instanceof SortParameter)) {
            String varType = this.getVariableInstanceType();
            String alias = varType.toLowerCase() + this.objectCount;
            whereClause = whereClause + "process =" + alias + ".processInstance";
            whereClause = whereClause + " AND " + alias + ".name = '" + this.fieldName + "'";
            whereClause = whereClause + " AND " + alias + ".value " + this.getPredicate();
            whereClause = whereClause + " AND " + alias + ".tokenVariableMap is not null";
        } else if (this.fieldName.equals("AccessLevel")) {
            whereClause = whereClause + "template.protectionKeys.id " + this.getPredicate();
        } else if (this.fieldName.equals("resourceGroup")) {
            whereClause = whereClause + "process.id = token" + this.objectCount + ".processInstance";
            whereClause = whereClause + " AND token" + this.objectCount + ".id =" + RESOURCEUSER_ALIAS + this.objectCount + ".id";
            whereClause = whereClause + " AND resourceuser" + this.objectCount + ".resourceGroupId" + this.getPredicate();
        } else if (this.fieldName.equals("tokenstatus")) {
            whereClause = whereClause + "process.id = token" + this.objectCount + ".processInstance";
            whereClause = whereClause + " AND token" + this.objectCount + "." + "status" + this.getStatusPredicate();
        } else if (!(this instanceof SortParameter)) {
            whereClause = this.fieldName.equals("status".toString()) ? whereClause + "process." + this.fieldName + this.getStatusPredicate() : whereClause + "process." + this.fieldName + this.getPredicate();
        }
        return whereClause;
    }

    private String getStatusPredicate() {
        if (this instanceof RangeParameter) {
            logger.error((Object)"Status cannot be searched using a RangeParameter.");
            return null;
        }
        if (this instanceof ListParameter) {
            ListParameter listParam = new ListParameter("status");
            for (Object obj : ((ListParameter)this).getValues()) {
                ProcessStatus status = ProcessStatus.valueOf(obj.toString());
                listParam.setFieldType(SearchType.NUMERIC);
                if (status == ProcessStatus.ACTIVE) {
                    listParam.addValue(ProcessStatus.CREATED.ordinal() + "");
                    listParam.addValue(ProcessStatus.RUNNING.ordinal() + "");
                    listParam.addValue(ProcessStatus.BUSY.ordinal() + "");
                    continue;
                }
                listParam.addValue(status.ordinal() + "");
            }
            return listParam.getPredicate();
        }
        ListParameter listParam = new ListParameter("status");
        ProcessStatus status = ProcessStatus.valueOf(((ValueParameter)this).getValue().toString());
        listParam.setFieldType(SearchType.NUMERIC);
        if (status == ProcessStatus.ACTIVE) {
            listParam.addValue(ProcessStatus.CREATED.ordinal() + "");
            listParam.addValue(ProcessStatus.RUNNING.ordinal() + "");
            listParam.addValue(ProcessStatus.BUSY.ordinal() + "");
        } else {
            listParam.addValue(status.ordinal() + "");
        }
        return listParam.getPredicate();
    }

    public abstract String getPredicate();

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParameterBase other = (SearchParameterBase)obj;
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }
}

