/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.util.jpdl.WFSJpdlXmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class FileReader
implements ITemplateReader {
    private File file;

    public FileReader(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    public WorkflowTemplate read() {
        WorkflowTemplate template = null;
        try {
            template = (WorkflowTemplate)new WFSJpdlXmlReader(new FileInputStream(this.file)).readProcessDefinition();
        }
        catch (TemplateReaderException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new TemplateReaderException("Template file does not exist", e);
        }
        catch (Exception e) {
            throw new TemplateReaderException("Failed to read template " + this.file.getAbsolutePath(), e);
        }
        return template;
    }
}

