/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.log.events.ProcessLogEvent;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.jbpm.logging.log.ProcessLog;

public class ProcessLogLogger
implements IWorkflowLogger {
    private static final Logger logger = Logger.getLogger(ProcessLogLogger.class);

    public boolean match(Object logEvent) {
        return logEvent instanceof ProcessLogEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object eventObj) {
        if (!(eventObj instanceof ProcessLogEvent)) {
            logger.debug((Object)"Not a ProcessLogEvent object. Ignored.");
            return;
        }
        ProcessLog processLog = ((ProcessLogEvent)eventObj).getLog();
        logger.debug((Object)("Storing process log to database. Process Log: " + processLog));
        Session session = HibernateContext.getContext().openSession();
        try {
            session.beginTransaction();
            session.saveOrUpdate((Object)processLog);
            session.getTransaction().commit();
            logger.debug((Object)("Stored process log to database. Process Log: " + processLog));
        }
        catch (Exception ex) {
            logger.error((Object)"Could not store the ProcessLog", (Throwable)ex);
            session.getTransaction().rollback();
        }
        finally {
            session.close();
        }
    }
}

