/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.log.LogUtil;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.events.WorkflowProcessStatusLogEvent;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import org.apache.log4j.Logger;
import org.jbpm.logging.log.ProcessLog;

public class ProcessStatusPerResourceLogger
implements IWorkflowLogger {
    private static final Logger logger = Logger.getLogger(ProcessStatusPerResourceLogger.class);

    public boolean match(Object logEvent) {
        return logEvent instanceof WorkflowProcessStatusLogEvent;
    }

    public void execute(Object eventObj) {
        if (!(eventObj instanceof WorkflowProcessStatusLogEvent)) {
            logger.debug((Object)"Not a WorkflowProcessStatusLogEvent object. Ignored.");
            return;
        }
        ProcessLog processLog = this.convertToProcessStatusLog((WorkflowProcessStatusLogEvent)eventObj);
        LogUtil.storeProcessLog(processLog);
    }

    private ProcessLog convertToProcessStatusLog(WorkflowProcessStatusLogEvent statusEvent) {
        ProcessStatusPerResourceLog pl = null;
        pl = statusEvent.isQueued() ? new ProcessQueuedPerResourceLog(statusEvent.getToken(), statusEvent.getNode(), statusEvent.getTaskInstance(), statusEvent.getResourceGroup(), statusEvent.getResource(), statusEvent.getStartTime(), statusEvent.getEndTime(), statusEvent.getOperationalStatus(), statusEvent.getAdminStatus()) : new ProcessStatusPerResourceLog(statusEvent.getToken(), statusEvent.getNode(), statusEvent.getTaskInstance(), statusEvent.getResourceGroup(), statusEvent.getResource(), statusEvent.getStartTime(), statusEvent.getEndTime(), statusEvent.getOperationalStatus(), statusEvent.getAdminStatus());
        return pl;
    }
}

