/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.log.events.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.messageprocessor.AbstractCommand;
import com.tandbergtv.workflow.messageprocessor.ICommand;
import com.tandbergtv.workflow.messageprocessor.locate.CompositeKeyMatcher;
import com.tandbergtv.workflow.messageprocessor.locate.RequestKeyLookup;
import com.tandbergtv.workflow.messageprocessor.locate.TokenLocatorException;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Document;

public abstract class BaseTokenCommand
extends AbstractCommand
implements ICommand {
    protected Marshaller marshaller = Marshaller.newMarshaller();
    protected TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final Logger logger = Logger.getLogger(BaseTokenCommand.class);
    private static final String ERROR_MESSAGE = "Failed to locate a token for the received message";

    protected BaseTokenCommand() {
    }

    protected Token getToken(WorkflowMessage message) throws TokenLocatorException {
        IMessageKey key = message.getKey();
        if (key != null && key.toString().length() > 0) {
            return new RequestKeyLookup().locate(message);
        }
        return new CompositeKeyMatcher().locate(message);
    }

    protected abstract WorkflowMessage executeImpl(Token var1, WorkflowMessage var2);

    public WorkflowMessage execute(WorkflowMessage message) {
        CustomToken token = null;
        try {
            token = (CustomToken)this.getToken(message);
        }
        catch (TokenLocatorException tle) {
            logger.error((Object)tle.getMessage(), (Throwable)tle);
            this.logMessage(message);
            return this.createErrorResponse(tle.getMessage(), message);
        }
        if (token == null) {
            String errorMsg = "Failed to locate a token for the received message[" + message.getMessageUID().getUID() + "]";
            logger.warn((Object)errorMsg);
            this.logMessage(message);
            return this.createErrorResponse(errorMsg, message);
        }
        IMessageUID uid = message.getMessageUID();
        if (!uid.isMessageOutgoing()) {
            Node node;
            logger.info((Object)("Located " + token + " for received message [" + uid + "]"));
            Resource resource = ResourceManager.getInstance().getResourceByToken(token.getId());
            if (resource == null && (node = token.getCurrentNode()) instanceof ResourceGroupAware) {
                String address = DeviceTypeUtil.getConnectionString(message.getSource());
                long id = ((ResourceGroupAware)node).getResourceGroupID();
                logger.debug((Object)(token + ", searching for resource in group " + id + " address " + address));
                resource = ResourceManager.getInstance().getResourceByConnectionString(address, id);
            }
            DefaultMediator.getInstance().send(new WorkflowMessageLogEvent(token, token.getNode(), true, resource, message));
        }
        return this.executeImpl(token, message);
    }

    private void logMessage(WorkflowMessage message) {
        try {
            Document messageDoc = this.marshaller.marshal(message);
            StringWriter writer = new StringWriter();
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(new DOMSource(messageDoc), new StreamResult(writer));
            String contents = writer.toString();
            logger.error((Object)("The Workflow Message that failed to locate the Token: " + contents));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to log the incoming Workflow Message[" + message.getMessageUID().getUID() + "] that failed to locate a Token."));
        }
    }
}

