/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor.locate;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.messageprocessor.locate.AbstractTokenLocator;
import com.tandbergtv.workflow.messageprocessor.locate.TokenLocatorException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class RequestKeyLookup
extends AbstractTokenLocator {
    public Token locate(WorkflowMessage message) throws TokenLocatorException {
        String uid = message.getMessageUID().getUID();
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        CustomToken token = service.getToken(new Long(message.getKey().toString()));
        if (message.getMessageUID().isMessageOutgoing()) {
            return token;
        }
        if (token.getStatus() != ProcessStatus.BUSY && token.getStatus() != ProcessStatus.RUNNING) {
            throw new TokenLocatorException("Message [" + uid + "]: found process " + token + ", but the process is not BUSY.");
        }
        Node node = this.getNode(token);
        if (!this.needsMessage(node, message)) {
            throw new TokenLocatorException(token + " is not expecting message [" + uid + "]");
        }
        return token;
    }
}

