/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.util;

import com.tandbergtv.workflow.pluginmanager.entities.AdaptorDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ManagementDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ScopeDescriptor;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.java.plugin.registry.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionParser {
    private ExtensionParser() {
    }

    public static final ResourceTypeDescriptor parseResourceTypeExtension(Extension extension, ClassLoader loader) {
        ResourceTypeDescriptor descriptor = new ResourceTypeDescriptor();
        descriptor.setExtensionId(extension.getId());
        descriptor.setPluginId(extension.getDeclaringPluginDescriptor().getId());
        Extension.Parameter param = extension.getParameter("systemId");
        descriptor.setSystemId(param.valueAsString());
        param = extension.getParameter("name");
        descriptor.setName(param.valueAsString());
        param = extension.getParameter("createDate");
        descriptor.setCreateDate(param.valueAsDate());
        param = extension.getParameter("description");
        if (param != null) {
            descriptor.setDescription(param.valueAsString());
        }
        if ((param = extension.getParameter("communication")) != null) {
            ExtensionParser.parseCommunication(param, descriptor);
        }
        param = extension.getParameter("management");
        ExtensionParser.parseManagement(param, descriptor);
        descriptor.setClassLoader(loader);
        return descriptor;
    }

    private static final void parseCommunication(Extension.Parameter parameter, ResourceTypeDescriptor descriptor) {
        Extension.Parameter param = parameter.getSubParameter("messages");
        ExtensionParser.parseMessages(param, descriptor);
        param = parameter.getSubParameter("adaptor");
        ExtensionParser.parseAdaptor(param, descriptor);
    }

    private static final void parseMessages(Extension.Parameter parameter, ResourceTypeDescriptor descriptor) {
        Hashtable<String, MessageDescriptor> messageMap = new Hashtable<String, MessageDescriptor>();
        Extension.Parameter param = parameter.getSubParameter("defaultProtocol");
        String defaultProtocol = param.valueAsString();
        descriptor.setDefaultProtocol(defaultProtocol);
        int missingUIDCounter = 0;
        Collection messages = parameter.getSubParameters("message");
        for (Extension.Parameter message : messages) {
            MessageDescriptor messageDesc = new MessageDescriptor();
            param = message.getSubParameter("name");
            messageDesc.setName(param.valueAsString());
            param = message.getSubParameter("uid");
            messageDesc.setUID(param.valueAsString());
            param = message.getSubParameter("protocol");
            String protocol = param != null ? param.valueAsString() : defaultProtocol;
            messageDesc.setProtocol(protocol);
            param = message.getSubParameter("description");
            if (param != null) {
                messageDesc.setDescription(param.valueAsString());
            }
            if (messageDesc.getUID() == null) {
                messageDesc.setUID("UNKNOWN_UID_" + Integer.toString(missingUIDCounter++));
            }
            messageMap.put(messageDesc.getUID(), messageDesc);
        }
        descriptor.setMessages(messageMap);
    }

    private static final void parseAdaptor(Extension.Parameter parameter, ResourceTypeDescriptor descriptor) {
        AdaptorDescriptor adaptorDesc = new AdaptorDescriptor();
        Extension.Parameter param = parameter.getSubParameter("default");
        if (param != null) {
            Extension.Parameter child = param.getSubParameter("messageIdentifierClass");
            if (child != null) {
                adaptorDesc.setMessageIdentifierClass(child.valueAsString());
            }
        } else {
            param = parameter.getSubParameter("custom");
            Extension.Parameter child = param.getSubParameter("class");
            adaptorDesc.setAdaptorClass(child.valueAsString());
            child = param.getSubParameter("scope");
            String scope = child != null ? child.valueAsString() : ScopeDescriptor.APPLICATION.toString();
            adaptorDesc.setScope(ScopeDescriptor.valueOf(scope));
            child = param.getSubParameter("init-params");
            if (child != null) {
                Map<String, String> properties = ExtensionParser.parseProperties(child);
                adaptorDesc.setProperties(properties);
            }
        }
        descriptor.setAdaptor(adaptorDesc);
    }

    private static final void parseManagement(Extension.Parameter parameter, ResourceTypeDescriptor descriptor) {
        Extension.Parameter child;
        ManagementDescriptor management = new ManagementDescriptor();
        Extension.Parameter param = parameter.getSubParameter("connectionType");
        management.setConnectionType(ExtensionParser.parseConnectionType(param.valueAsString()));
        param = parameter.getSubParameter("initialization");
        if (param != null) {
            child = param.getSubParameter("strategyClass");
            management.setInitializationStrategyClass(child.valueAsString());
            child = param.getSubParameter("init-params");
            if (child != null) {
                Map<String, String> properties = ExtensionParser.parseProperties(child);
                management.setInitializationProperties(properties);
            }
        }
        if ((param = parameter.getSubParameter("heartbeat")) != null) {
            child = param.getSubParameter("connectionType");
            management.setHeartbeatConnectionType(ExtensionParser.parseConnectionType(child.valueAsString()));
            child = param.getSubParameter("strategyClass");
            management.setHeartbeatStrategyClass(child.valueAsString());
            child = param.getSubParameter("init-params");
            if (child != null) {
                Map<String, String> hbProperties = ExtensionParser.parseProperties(child);
                management.setHeartbeatProperties(hbProperties);
            }
        }
        descriptor.setManagement(management);
    }

    private static ResourceConnectionType parseConnectionType(String connectionType) {
        ResourceConnectionType result = null;
        if (connectionType != null) {
            if (connectionType.equals("URL")) {
                result = ResourceConnectionType.URL;
            } else if (connectionType.equals("IP/Port")) {
                result = ResourceConnectionType.IP_PORT;
            } else if (connectionType.equals("Email")) {
                result = ResourceConnectionType.EMAIL;
            }
        }
        return result;
    }

    private static Map<String, String> parseProperties(Extension.Parameter parameter) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Extension.Parameter property : parameter.getSubParameters("parameter")) {
            Extension.Parameter key = property.getSubParameter("key");
            Extension.Parameter value = property.getSubParameter("value");
            if (key.valueAsString() == null) continue;
            properties.put(key.valueAsString(), value.valueAsString());
        }
        return properties;
    }
}

