/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.util;

import com.tandbergtv.workflow.pluginmanager.entities.FailureDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.IntegrityCheckReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupPluginValidator {
    private static final Logger logger = Logger.getLogger(ResourceGroupPluginValidator.class);
    private static final String SYSTEM_ID_REGEX = "\\p{Alnum}{2}";

    private ResourceGroupPluginValidator() {
    }

    public static FailureDescriptor validateDescriptor(ResourceGroupDescriptor descriptor, boolean alreadyExists) {
        logger.debug((Object)"Entering method...");
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (alreadyExists) {
            errorMessages.add("Resource Group with name: " + descriptor.getName() + " is already defined.");
        }
        String message = null;
        message = ResourceGroupPluginValidator.validateSystemId(descriptor.getSystemId());
        if (message != null) {
            errorMessages.add(message);
        }
        message = null;
        message = ResourceGroupPluginValidator.validateName(descriptor.getName());
        if (message != null) {
            errorMessages.add(message);
        }
        message = null;
        message = ResourceGroupPluginValidator.validateAccessLevel(descriptor.getAccessLevel());
        if (message != null) {
            errorMessages.add(message);
        }
        message = null;
        message = ResourceGroupPluginValidator.validateInternallyAcquired(descriptor.getIsInternallyAcquired());
        if (message != null) {
            errorMessages.add(message);
        }
        if (errorMessages.size() > 0) {
            FailureDescriptor fd = new FailureDescriptor(errorMessages);
            fd.setId(descriptor.getSystemId());
            fd.setExtensionId(descriptor.getExtensionId());
            fd.setName(descriptor.getName());
            return fd;
        }
        return null;
    }

    private static String validateInternallyAcquired(Boolean isInternallyAcquired) {
        if (isInternallyAcquired == null) {
            return "IsInternallyAcquired cannot be blank or just spaces.";
        }
        return null;
    }

    private static String validateAccessLevel(String accessLevel) {
        if (accessLevel == null) {
            return "Access Level cannot be blank or just spaces.";
        }
        return null;
    }

    private static String validateSystemId(String systemId) {
        if (systemId == null) {
            return "System ID cannot be blank or just spaces.";
        }
        if (!systemId.matches(SYSTEM_ID_REGEX)) {
            return "System ID must be exactly 2 characters, and contain only alphanumeric values.";
        }
        return null;
    }

    private static String validateName(String name) {
        if (name == null) {
            return "Name cannot be blank or just spaces.";
        }
        return null;
    }

    public static FailureDescriptor validateExtension(Extension extension, IntegrityCheckReport report) {
        logger.debug((Object)"Entering method...");
        List<String> messages = ResourceGroupPluginValidator.getFrameworkValidationFailureMessages(extension, report);
        return ResourceGroupPluginValidator.prepareFailureDescriptor(extension, messages);
    }

    private static List<String> getFrameworkValidationFailureMessages(Extension extension, IntegrityCheckReport report) {
        ArrayList<String> validationFailureMessages = new ArrayList<String>();
        if (!extension.isValid()) {
            validationFailureMessages.add("The Plugin Extension has failed framework validation.");
            for (IntegrityCheckReport.ReportItem item : report.getItems()) {
                if (item.getSeverity() != IntegrityCheckReport.Severity.ERROR) continue;
                String sourceId = item.getSource() != null ? item.getSource().getId() : null;
                String pluginId = extension.getDeclaringPluginDescriptor().getId();
                String extensionId = extension.getId();
                if (!extensionId.equals(sourceId) && !pluginId.equals(sourceId)) continue;
                validationFailureMessages.add(item.getMessage());
            }
        }
        return validationFailureMessages;
    }

    private static FailureDescriptor prepareFailureDescriptor(Extension extension, List<String> messages) {
        FailureDescriptor result = null;
        if (messages.size() > 0) {
            result = new FailureDescriptor();
            result.setPluginId(extension.getDeclaringPluginDescriptor().getId());
            result.setExtensionId(extension.getId());
            Extension.Parameter param = extension.getParameter("systemId");
            if (param != null && param.rawValue().trim().length() > 0) {
                result.setId(param.valueAsString());
            }
            if ((param = extension.getParameter("name")) != null && param.rawValue().trim().length() > 0) {
                result.setName(param.valueAsString());
            }
            result.setErrorMessages(messages);
            result.setSummaryMessage("The Plugin Extension has failed basic validation.");
        }
        return result;
    }
}

