/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.log.events.WorkflowProcessStatusLogEvent;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.AllocationUtility;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResourceQueueManager {
    private static final Logger logger = Logger.getLogger(ResourceQueueManager.class);
    private ResourceManagerContext context;

    ResourceQueueManager(ResourceManagerContext context) {
        this.context = context;
    }

    boolean queueToken(long resourceGroupId, long tokenId) {
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = container.getResourceGroup();
        ResourceGroupQueueItem newQueueItem = new ResourceGroupQueueItem();
        newQueueItem.setResourceGroup(resourceGroup);
        newQueueItem.setTokenId(tokenId);
        return this.enqueueItem(resourceGroup, newQueueItem);
    }

    boolean dequeueToken(long resourceGroupId, CustomToken token) {
        boolean result = false;
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = container.getResourceGroup();
        ResourceGroupQueueItem queueItem = this.dequeueItem(resourceGroup, token.getId());
        if (queueItem != null) {
            result = true;
            this.storeProcessQueuedLog(resourceGroup, null, queueItem, token);
            this.context.storeResourceGroup(resourceGroup.getId());
        }
        return result;
    }

    boolean repositionQueuedToken(long resourceGroupId, long tokenId) {
        boolean result = false;
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = container.getResourceGroup();
        ResourceGroupQueueItem queueItem = this.dequeueItem(resourceGroup, tokenId);
        if (queueItem != null) {
            result = this.enqueueItem(resourceGroup, queueItem);
        }
        return result;
    }

    boolean moveQueueItemToTop(long resourceGroupId, long queueItemId) {
        return this.moveQueueItemToEnd(resourceGroupId, queueItemId, true);
    }

    boolean moveQueueItemToBottom(long resourceGroupId, long queueItemId) {
        return this.moveQueueItemToEnd(resourceGroupId, queueItemId, false);
    }

    boolean moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) {
        return this.moveQueueItem(resourceGroupId, queueItemId, neighborQueueItemId, true);
    }

    boolean moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) {
        return this.moveQueueItem(resourceGroupId, queueItemId, neighborQueueItemId, false);
    }

    private boolean enqueueItem(ResourceGroup resourceGroup, ResourceGroupQueueItem queueItem) {
        List<ResourceGroupQueueItem> queueItems = resourceGroup.getQueue().getQueuedItems();
        for (ResourceGroupQueueItem currentQueueItem : resourceGroup.getQueue().getQueuedItems()) {
            if (queueItem.getTokenId() != currentQueueItem.getTokenId()) continue;
            logger.error((Object)("The Token: " + currentQueueItem.getTokenId() + " is already queued for [group " + resourceGroup.getId() + "]: " + resourceGroup.getName() + ", and cannot be enqueued again."));
            return false;
        }
        queueItem.setResourceGroup(resourceGroup);
        long tokenId = queueItem.getTokenId();
        int size = queueItems.size();
        logger.debug((Object)("[" + tokenId + "], adding to queue for [group " + resourceGroup.getId() + "] of size " + size));
        long current = System.currentTimeMillis();
        int insertIndex = this.getInsertIndex(queueItems, queueItem);
        queueItems.add(insertIndex, queueItem);
        this.context.queuedTokenLookup.put(queueItem.getTokenId(), resourceGroup.getId());
        double diff = (double)(System.currentTimeMillis() - current) / 1000.0;
        logger.debug((Object)("[" + tokenId + "], added to queue for [group " + resourceGroup.getId() + "] at index " + insertIndex + " in " + diff + " sec"));
        long resourceGroupId = resourceGroup.getId();
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        container.notifyQueue();
        this.context.storeResourceGroup(resourceGroupId);
        return true;
    }

    private int getInsertIndex(List<ResourceGroupQueueItem> queueItems, ResourceGroupQueueItem queueItem) {
        int insertIndex = Collections.binarySearch(queueItems, queueItem, new Comparator<ResourceGroupQueueItem>(){

            @Override
            public int compare(ResourceGroupQueueItem i1, ResourceGroupQueueItem i2) {
                ProcessPriority p1 = ResourceQueueManager.this.getToken(i1.getTokenId()).getProcessInstance().getPriority();
                ProcessPriority p2 = ResourceQueueManager.this.getToken(i2.getTokenId()).getProcessInstance().getPriority();
                int diff = p2.compareTo(p1);
                if (diff != 0) {
                    return diff;
                }
                diff = i1.getQueuedDate().compareTo(i2.getQueuedDate());
                if (diff != 0) {
                    return diff;
                }
                return -1;
            }
        });
        return -(insertIndex + 1);
    }

    private ResourceGroupQueueItem dequeueItem(ResourceGroup resourceGroup, long tokenId) {
        ResourceGroupQueueItem result = null;
        List<ResourceGroupQueueItem> queueItems = resourceGroup.getQueue().getQueuedItems();
        ListIterator<ResourceGroupQueueItem> i = queueItems.listIterator();
        while (i.hasNext()) {
            ResourceGroupQueueItem queueItem = i.next();
            if (queueItem.getTokenId() != tokenId) continue;
            result = queueItem;
            i.remove();
            this.context.queuedTokenLookup.remove(tokenId);
            logger.debug((Object)("Queue Item with Token: " + queueItem.getTokenId() + " removed from " + "queue for [group " + queueItem.getResourceGroup().getId() + "]"));
            break;
        }
        return result;
    }

    private boolean moveQueueItemToEnd(long resourceGroupId, long queueItemId, boolean moveTop) {
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = container.getResourceGroup();
        List<ResourceGroupQueueItem> queueItems = resourceGroup.getQueue().getQueuedItems();
        ResourceGroupQueueItem queueItem = this.findQueueItem(queueItems, queueItemId);
        if (queueItem == null) {
            return false;
        }
        if (queueItems.size() > 1) {
            queueItems.remove(queueItem);
            int index = moveTop ? 0 : queueItems.size() - 1;
            ResourceGroupQueueItem endQueueItem = queueItems.get(index);
            this.copyPriority(endQueueItem, queueItem);
            if (!moveTop) {
                ++index;
            }
            queueItems.add(index, queueItem);
        }
        this.context.storeResourceGroup(resourceGroupId);
        return true;
    }

    private boolean moveQueueItem(long resourceGroupId, long queueItemId, long neighborQueueItemId, boolean moveUp) {
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = container.getResourceGroup();
        List<ResourceGroupQueueItem> queueItems = resourceGroup.getQueue().getQueuedItems();
        ResourceGroupQueueItem queueItem = this.findQueueItem(queueItems, queueItemId);
        if (queueItem == null) {
            return false;
        }
        ResourceGroupQueueItem neighbour = this.findQueueItem(queueItems, neighborQueueItemId);
        if (neighbour != null) {
            queueItems.remove(queueItem);
            this.copyPriority(neighbour, queueItem);
            int index = queueItems.indexOf(neighbour) + (moveUp ? 0 : 1);
            queueItems.add(index, queueItem);
        }
        this.context.storeResourceGroup(resourceGroupId);
        return true;
    }

    private ResourceGroupQueueItem findQueueItem(List<ResourceGroupQueueItem> queueItems, long queueItemId) {
        ResourceGroupQueueItem match = null;
        for (ResourceGroupQueueItem item : queueItems) {
            if (item.getId() != queueItemId) continue;
            match = item;
            break;
        }
        return match;
    }

    private void copyPriority(ResourceGroupQueueItem source, ResourceGroupQueueItem target) {
        CustomToken token = this.getToken(source.getTokenId());
        WorkflowProcess process = (WorkflowProcess)token.getProcessInstance();
        ProcessPriority priority = process.getPriority();
        CustomToken targetToken = this.getToken(target.getTokenId());
        QueueOrderChangedEvent event = new QueueOrderChangedEvent(this.context.manager, targetToken, priority);
        this.context.mediator.send(event);
    }

    boolean tryToAllocate(long resourceGroupId) {
        return this.tryAllocation(resourceGroupId, null, -1L);
    }

    boolean tryToAllocate(long resourceGroupId, String connectionString, long tokenId) {
        return this.tryAllocation(resourceGroupId, connectionString, tokenId);
    }

    boolean isResourceAvailableForAllocation(long resourceId) {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return false;
        }
        return AllocationUtility.isResourceAvailable(container.getResource());
    }

    void releaseToken(CustomToken token) {
        ResourceContainer container = this.context.findResourceByToken(token.getId());
        if (container == null) {
            return;
        }
        Resource resource = container.getResource();
        ResourceUser userToRelease = null;
        WorkflowProcess process = token.getProcessInstance();
        for (ResourceUser user : resource.getUsers()) {
            if (user.getId() != token.getId()) continue;
            userToRelease = user;
            break;
        }
        if (userToRelease == null) {
            logger.debug((Object)("Attempting to release [" + process.getId() + "] token: " + token.getId() + ", but Token is not using a Resource."));
            return;
        }
        resource.removeUser(userToRelease);
        this.storeProcessStatusLog(resource, userToRelease, token);
        this.context.stateManager.tryTakeResourceOffline(container);
        this.context.storeResource(resource.getId());
        logger.info((Object)(token + " released resource [" + resource.getId() + "]: " + resource.getName()));
        this.notifyQueuesByResource(resource.getId());
    }

    private boolean tryAllocation(long resourceGroupId, String connectionString, long tokenId) {
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        if (container == null) {
            return false;
        }
        ResourceGroup resourceGroup = container.getResourceGroup();
        ResourceGroupQueueItem queueItem = this.getItemForAllocation(resourceGroup, tokenId);
        if (queueItem == null) {
            return false;
        }
        if (connectionString == null && !resourceGroup.isInternallyAcquired()) {
            CustomToken token = this.getToken(tokenId);
            long processId = token.getProcessInstance().getId();
            long nodeId = token.getNode().getId();
            String msg = "Received an external allocation request for Process[" + processId + "], [Node " + nodeId + "] with an invalid(null) Resource Connection String.";
            logger.error((Object)msg);
            return false;
        }
        Resource resource = this.getAllocatedResource(resourceGroupId, connectionString);
        if (resource == null) {
            return false;
        }
        if (!this.isValidAllocatedResource(resourceGroup, resource)) {
            return false;
        }
        this.allocateResourceForQueueItem(resourceGroup, resource, queueItem);
        this.context.storeResourceAndGroup(resource.getId(), resourceGroup.getId());
        return true;
    }

    private ResourceGroupQueueItem getItemForAllocation(ResourceGroup resourceGroup, long tokenId) {
        ResourceGroupQueueItem queueItemToAllocate = null;
        boolean isQueueModified = false;
        List<ResourceGroupQueueItem> queueItems = resourceGroup.getQueue().getQueuedItems();
        if (queueItems == null) {
            return queueItemToAllocate;
        }
        ListIterator<ResourceGroupQueueItem> itr = queueItems.listIterator();
        while (itr.hasNext()) {
            ResourceGroupQueueItem queueItem = itr.next();
            CustomToken token = this.getToken(queueItem.getTokenId());
            if (this.isValidQueuedToken(token)) {
                if (!resourceGroup.isInternallyAcquired() && queueItem.getTokenId() != tokenId) continue;
                queueItemToAllocate = queueItem;
                break;
            }
            itr.remove();
            this.context.queuedTokenLookup.remove(token.getId());
            this.storeProcessQueuedLog(resourceGroup, null, queueItem, token);
            isQueueModified = true;
        }
        if (isQueueModified) {
            this.context.storeResourceGroup(resourceGroup.getId());
        }
        return queueItemToAllocate;
    }

    private boolean isValidQueuedToken(Token token) {
        boolean result = false;
        if (token == null) {
            logger.error((Object)("Failed to get the Token[" + token.getId() + "] from the EngineDriver."));
            return result;
        }
        result = ((CustomToken)token).getStatus() == ProcessStatus.QUEUED;
        return result;
    }

    private Resource getAllocatedResource(long resourceGroupId, String connectionString) {
        Resource allocatedResource = null;
        ResourceGroupContainer rgContainer = this.context.resourceGroups.get(resourceGroupId);
        ResourceGroup resourceGroup = rgContainer.getResourceGroup();
        if (resourceGroup.getResources().size() == 0) {
            logger.warn((Object)("There are no resources present in [group " + resourceGroup.getId() + "]: " + resourceGroup.getName()));
            return allocatedResource;
        }
        if (resourceGroup.isInternallyAcquired()) {
            try {
                ResourceGroup clone = this.context.manager.cloneResourceGroup(resourceGroup);
                Resource resource = rgContainer.getAllocationStrategy().allocateResource(clone);
                if (resource != null) {
                    ResourceContainer container = this.context.resources.get(resource.getId());
                    allocatedResource = container != null ? container.getResource() : null;
                }
            }
            catch (Exception ex) {
                String msg = "The allocation strategy for [group " + resourceGroupId + "]: " + resourceGroup.getName() + " has failed when attempting to allocate a Resource.";
                logger.warn((Object)msg, (Throwable)ex);
            }
        } else {
            for (ResourceContainer container : this.context.resources.values()) {
                Resource resource = container.getResource();
                if (resource.getConnectionString() == null || !resource.getConnectionString().equals(connectionString)) continue;
                allocatedResource = resource;
                break;
            }
        }
        return allocatedResource;
    }

    private boolean isValidAllocatedResource(ResourceGroup resourceGroup, Resource resource) {
        String groupMsg;
        String string = groupMsg = resourceGroup.isInternallyAcquired() ? "externally acquired " : "";
        if (!resourceGroup.getResources().contains(resource)) {
            String msg = "[resource " + resource.getId() + "]: " + resource.getName() + " has been allocated when processing allocation request for " + groupMsg + "[group " + resourceGroup.getId() + "]: " + resourceGroup.getName() + ", but resource does not belong to the Resource Group. Ignoring allocation.";
            logger.error((Object)msg);
            return false;
        }
        if (!this.isResourceAvailableForAllocation(resource.getId())) {
            String msg = "[resource " + resource.getId() + "]: " + resource.getName() + " has been allocated when processing allocation request for " + groupMsg + "[group " + resourceGroup.getId() + "]: " + resourceGroup.getName() + ", but resource is not available for allocation. Ignoring allocation.";
            logger.error((Object)msg);
            return false;
        }
        return true;
    }

    private void allocateResourceForQueueItem(ResourceGroup resourceGroup, Resource resource, ResourceGroupQueueItem queueItem) {
        long tokenId = queueItem.getTokenId();
        CustomToken token = this.getToken(tokenId);
        resourceGroup.getQueue().getQueuedItems().remove(queueItem);
        this.context.queuedTokenLookup.remove(tokenId);
        ResourceUser user = new ResourceUser(queueItem.getTokenId(), resourceGroup.getId());
        resource.addUser(user);
        resource.getOrderedListOfResGroups().remove(resourceGroup);
        resource.getOrderedListOfResGroups().add(resourceGroup);
        this.storeProcessQueuedLog(resourceGroup, resource, queueItem, token);
        Resource clone = this.context.manager.cloneResource(resource);
        ResourceAcquiredEvent resAcqEvent = new ResourceAcquiredEvent(token, clone);
        this.context.mediator.sendAsync(resAcqEvent);
        String resType = resourceGroup.isInternallyAcquired() ? "" : "externally acquired ";
        logger.info((Object)(token + " assigned " + resType + "resource [" + resource.getId() + "]: " + resource.getName() + " via group [" + resourceGroup.getId() + "]"));
    }

    void notifyQueuesByResource(long resourceId) {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return;
        }
        List<ResourceGroup> orderedGroupList = container.getResource().getOrderedListOfResGroups();
        if (orderedGroupList != null) {
            for (ResourceGroup group : orderedGroupList) {
                logger.debug((Object)("notifying: " + group.getName()));
                ResourceGroupContainer rgContainer = this.context.resourceGroups.get(group.getId());
                if (rgContainer == null) continue;
                rgContainer.notifyQueue();
            }
        }
    }

    private void storeProcessQueuedLog(ResourceGroup resourceGroup, Resource resource, ResourceGroupQueueItem queueItem, CustomToken token) {
        ResourceGroup cloneGroup = new ResourceGroup(resourceGroup.getId());
        Resource cloneResource = null;
        if (resource != null) {
            cloneResource = new Resource(resource.getId());
        }
        Date startTime = queueItem.getQueuedDate();
        Date endTime = new Date();
        WorkflowProcessStatusLogEvent event = new WorkflowProcessStatusLogEvent(true, token, token.getNode(), null, cloneGroup, cloneResource, startTime, endTime, token.getStatus(), token.getRequestedStatus());
        this.context.mediator.sendAsync(event);
    }

    private void storeProcessStatusLog(Resource resource, ResourceUser user, CustomToken token) {
        long resourceGroupId = user.getResourceGroupId();
        ResourceGroup cloneGroup = new ResourceGroup(resourceGroupId);
        Resource cloneResource = new Resource(resource.getId());
        Date startTime = user.getUsageStartDate();
        Date endTime = new Date();
        WorkflowProcessStatusLogEvent event = new WorkflowProcessStatusLogEvent(false, token, token.getNode(), null, cloneGroup, cloneResource, startTime, endTime, token.getStatus(), token.getRequestedStatus());
        this.context.mediator.sendAsync(event);
    }

    private CustomToken getToken(long tokenId) {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        return service.getToken(Long.valueOf(tokenId));
    }
}

