/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.sanmanager.config;

import com.tandbergtv.workflow.sanmanager.config.SANConfigurationException;
import com.tandbergtv.workflow.sanmanager.entities.DriveCapacityUnit;
import com.tandbergtv.workflow.sanmanager.entities.SANConfiguration;
import com.tandbergtv.workflow.sanmanager.entities.SANDrive;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SANConfigurationReader {
    private static final String DRIVE_CONFIG_FILE = "/sanconfiguration.xml";
    private static final String DRIVE_CONFIG_SCHEMA_FILE = "sanconfiguration.xsd";
    private static final String DRIVE_CONFIG_NAMESPACE = "http://www.tandergtv.com/workflow/sanmanager/sanconfiguration";
    private static final Logger logger = Logger.getLogger(SANConfigurationReader.class);
    private static final DocumentBuilderFactory DOM_FACTORY = SANConfigurationReader.initializeDOMFactory();

    public static SANConfiguration readConfiguration() throws SANConfigurationException {
        String msg;
        SANConfiguration configuration = new SANConfiguration();
        Class<SANConfigurationReader> c = SANConfigurationReader.class;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String url = properties.getProperty("SANManager.ServiceURL");
            if (url == null || url.trim().length() == 0) {
                String msg2 = "No webservice URL specified in the application properties for the SAN Configuration.";
                throw new SANConfigurationException(msg2);
            }
            new URL(url);
            configuration.setServiceURL(url);
        }
        catch (SANConfigurationException se) {
            throw se;
        }
        catch (MalformedURLException mue) {
            String msg3 = "The webservice URL specified in the application properties for the SAN Configuration is invalid.";
            throw new SANConfigurationException(msg3, mue);
        }
        catch (Exception ex) {
            String msg4 = "Failed to read the WebService URL required by the SAN Configuration to fetch Drive information.";
            throw new SANConfigurationException(msg4, ex);
        }
        try {
            InputStream configStream = c.getResourceAsStream(DRIVE_CONFIG_FILE);
            DocumentBuilder domBuilder = DOM_FACTORY.newDocumentBuilder();
            Document configDoc = domBuilder.parse(configStream);
            NodeList childNodes = configDoc.getElementsByTagNameNS(DRIVE_CONFIG_NAMESPACE, "SAN-Drives");
            Element driveListElement = (Element)childNodes.item(0);
            childNodes = driveListElement.getElementsByTagName("SAN-Drive");
            ArrayList<SANDrive> driveList = new ArrayList<SANDrive>();
            for (int index = 0; index < childNodes.getLength(); ++index) {
                driveList.add(SANConfigurationReader.parseDrive((Element)childNodes.item(index)));
            }
            configuration.setDrives(driveList);
        }
        catch (ParserConfigurationException ex) {
            msg = "Failed to create the DocumentBuilder to parse the Drive Configuration File.";
            throw new SANConfigurationException(msg, ex);
        }
        catch (SAXException ex) {
            msg = "Failed to load the Drive Configuration File or Schema, the XML configuration is not valid.";
            throw new SANConfigurationException(msg, ex);
        }
        catch (IOException ex) {
            msg = "Failed to read the Drive Configuration File or Schema.";
            throw new SANConfigurationException(msg, ex);
        }
        catch (Exception ex) {
            msg = "Failed to parse the Drive Configuration File.";
            throw new SANConfigurationException(msg, ex);
        }
        return configuration;
    }

    private static SANDrive parseDrive(Element driveElement) {
        SANDrive drive = new SANDrive();
        String value = driveElement.getAttribute("id");
        long id = Long.parseLong(value);
        drive.setId(id);
        value = driveElement.getAttribute("name");
        drive.setName(value);
        Element element = SANConfigurationReader.getChildElement(driveElement, "Path");
        drive.setPath(element.getTextContent());
        element = SANConfigurationReader.getChildElement(driveElement, "StorageCapacity");
        value = element.getAttribute("unit");
        DriveCapacityUnit unit = SANConfigurationReader.parseCapacityUnit(value);
        drive.setCapacity(Double.parseDouble(element.getTextContent()), unit);
        drive.setDisplayUnit(unit);
        element = SANConfigurationReader.getChildElement(driveElement, "WarningStatusThreshold");
        int threshold = Integer.parseInt(element.getTextContent());
        drive.setWarningThreshold(threshold);
        element = SANConfigurationReader.getChildElement(driveElement, "ErrorStatusThreshold");
        threshold = Integer.parseInt(element.getTextContent());
        drive.setErrorThreshold(threshold);
        return drive;
    }

    private static DriveCapacityUnit parseCapacityUnit(String value) {
        DriveCapacityUnit unit = null;
        if (value == null) {
            return unit;
        }
        if ((value = value.trim()).equals("Byte")) {
            unit = DriveCapacityUnit.BYTE;
        } else if (value.equals("KB")) {
            unit = DriveCapacityUnit.KILOBYTE;
        } else if (value.equals("MB")) {
            unit = DriveCapacityUnit.MEGABYTE;
        } else if (value.equals("GB")) {
            unit = DriveCapacityUnit.GIGABYTE;
        } else if (value.equals("TB")) {
            unit = DriveCapacityUnit.TERABYTE;
        }
        return unit;
    }

    private static Element getChildElement(Element element, String childElementName) {
        NodeList list = element.getElementsByTagName(childElementName);
        return (Element)list.item(0);
    }

    private static DocumentBuilderFactory initializeDOMFactory() {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream schemaStream = SANConfigurationReader.class.getResourceAsStream(DRIVE_CONFIG_SCHEMA_FILE);
            StreamSource schemaFile = new StreamSource(schemaStream);
            Schema schema = schemaFactory.newSchema(schemaFile);
            domFactory.setSchema(schema);
        }
        catch (SAXException ex) {
            logger.warn((Object)"Failed to load the XML Schema for the Drive Configuration, will not validate the Drive Configuration XML document.", (Throwable)ex);
        }
        return domFactory;
    }
}

