/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public final class FileUtility {
    private static Logger logger = Logger.getLogger(FileUtility.class);

    private FileUtility() {
    }

    public static String readFileContents(String filePath) throws FileNotFoundException, IOException {
        File file = new File(filePath);
        return FileUtility.readFileContents(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileContents(File file) throws FileNotFoundException, IOException {
        BufferedReader reader = null;
        String contents = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            contents = FileUtility.readContents(reader);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)("Failed to close file being read: " + file.getAbsolutePath()), (Throwable)ex);
            }
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamContents(InputStream inStream) throws IOException {
        BufferedReader reader = null;
        String contents = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inStream));
            contents = FileUtility.readContents(reader);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Failed to close stream being read.", (Throwable)ex);
            }
        }
        return contents;
    }

    private static String readContents(BufferedReader reader) throws IOException {
        StringBuffer messageBuffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            messageBuffer.append(line);
            messageBuffer.append(System.getProperty("line.separator"));
        }
        return messageBuffer.toString();
    }
}

