/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.n2bb.user.UserManager;
import com.tandbergtv.watchpoint.watchfolder.core.WatchFolderManager;
import com.tandbergtv.workflow.adaptor.AdaptorManager;
import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.dao.HibernateContext;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.message.MessageRegistry;
import com.tandbergtv.workflow.message.queue.MessageQueueService;
import com.tandbergtv.workflow.monitor.AlertSystemHealthManager;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.sanmanager.SANManager;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.InitializationError;
import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class LifecycleListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(LifecycleListener.class);

    public void contextInitialized(ServletContextEvent arg0) {
        logger.info((Object)"Initializing web application...");
        if (!LicenseManager.getInstance().isExpirationDateValid()) {
            return;
        }
        try {
            HibernateContext.getContext().initializeContext();
            WatchPointPluginManager.getInstance().initialize();
            WorkflowLogManager.getInstance().initialize();
            MessageQueueService.getService().start();
            EngineDriver driver = EngineDriver.getInstance();
            driver.init();
            AuthorizationManager.getInstance().init();
            MessageRegistry.getInstance().initialize();
            AdaptorManager.getInstance().initialize();
            UserManager.getInstance().init();
            ResourceManager.getInstance().initialize();
            SANManager.getInstance().initialize();
            AlertSystemHealthManager.getInstance().initialize();
            driver.postInit();
            WatchFolderManager monitor = WatchFolderManager.getInstance();
            ApplicationProperties properties = ApplicationProperties.getInstance();
            monitor.setConfiguration(properties.getProperty("WorkflowApp.ConfigPath") + File.separator + properties.getProperty("monitor.config"));
            monitor.initialize();
        }
        catch (Exception ex) {
            String msg = "Error while initializing the Workflow Application: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            throw new InitializationError(msg, ex);
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        WatchFolderManager.getInstance().shutdown();
        try {
            AlertSystemHealthManager.getInstance().shutdown();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Alert System Health Manager.", (Throwable)ex);
        }
        try {
            SANManager.getInstance().shutdown();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the SAN Manager.", (Throwable)ex);
        }
        try {
            ResourceManager.getInstance().shutdown();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Resource Manager.", (Throwable)ex);
        }
        try {
            AdaptorManager.getInstance().destroy();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Adaptor Manager.", (Throwable)ex);
        }
        try {
            MessageRegistry.getInstance().destroy();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Message Registry.", (Throwable)ex);
        }
        try {
            AuthorizationManager.getInstance().destroy();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Authorization Manager.", (Throwable)ex);
        }
        MessageQueueService.getService().stop();
        try {
            EngineDriver.getInstance().destroy();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Engine Driver.", (Throwable)ex);
        }
        try {
            WorkflowLogManager.getInstance().destroy();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the message logger.", (Throwable)ex);
        }
        try {
            WatchPointPluginManager.getInstance().shutdown();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Plugin Manager.", (Throwable)ex);
        }
        try {
            HibernateContext.getContext().closeContext();
        }
        catch (Exception ex) {
            logger.error((Object)"Error while shutting down the Hibernate Context.", (Throwable)ex);
        }
        logger.info((Object)"Web application destroyed");
    }
}

