/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.auth.Credentials;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.formbeans.PauseResumeForm;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class PauseResumeAction
extends BaseDispatchAction {
    private static final Logger log = Logger.getLogger(PauseResumeAction.class);
    private static final String ACTION_FORWARD_SUCCESS = "loginSuccess";
    private static final String ACTION_FORWARD_FAILURE = "loginFailure";
    private static final String DISPLAY_ERRORS = "pauseAll.resumeAll.errors";
    private static final String DISPLAY_MESSAGE = "pauseAll.resumeAll.messages";

    public ActionForward resumeAllWorkOrder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = ACTION_FORWARD_FAILURE;
        ActionMessages messages = new ActionMessages();
        PauseResumeForm pauseResumeForm = (PauseResumeForm)form;
        if (!this.checkLogin(request, pauseResumeForm)) {
            messages.add("invalid.user.credentials", new ActionMessage("invalid.user.credentials", true));
            this.saveMessages(request, messages);
            return mapping.findForward(forward);
        }
        int count = 0;
        ServiceRegistry registry = ServiceRegistry.getDefault();
        try {
            count = registry.lookup(IProcessSearchService.class).count(ProcessStatus.PAUSED);
            registry.lookup(IProcessManagerService.class).resume();
            messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)(count + " work order(s) are scheduled to resume.")));
            forward = ACTION_FORWARD_SUCCESS;
        }
        catch (Exception e) {
            log.error((Object)"Exception while resuming work orders", (Throwable)e);
            messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)"Failed to resume all work orders"));
        }
        this.saveMessages(request, messages);
        this.saveErrors(request, messages);
        pauseResumeForm.reset();
        return mapping.findForward(forward);
    }

    public ActionForward pauseAllWorkOrder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = ACTION_FORWARD_FAILURE;
        ActionMessages messages = new ActionMessages();
        PauseResumeForm pauseResumeForm = (PauseResumeForm)form;
        if (!this.checkLogin(request, pauseResumeForm)) {
            messages.add("invalid.user.credentials", new ActionMessage("invalid.user.credentials", true));
            this.saveMessages(request, messages);
            return mapping.findForward(forward);
        }
        ArrayList<ProcessStatus> statusList = new ArrayList<ProcessStatus>();
        statusList.add(ProcessStatus.ACTIVE);
        statusList.add(ProcessStatus.QUEUED);
        statusList.add(ProcessStatus.BRANCHED);
        int count = 0;
        ServiceRegistry registry = ServiceRegistry.getDefault();
        try {
            count = registry.lookup(IProcessSearchService.class).count(statusList);
            registry.lookup(IProcessManagerService.class).pause();
            forward = ACTION_FORWARD_SUCCESS;
            messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)(count + " work order(s) are scheduled to pause.")));
        }
        catch (Exception e) {
            log.error((Object)"Exception while pausing work orders", (Throwable)e);
            messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)"Failed to pause all work orders"));
        }
        this.saveMessages(request, messages);
        this.saveErrors(request, messages);
        pauseResumeForm.reset();
        return mapping.findForward(forward);
    }

    public ActionForward goToLogin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(ACTION_FORWARD_FAILURE);
    }

    private boolean checkLogin(HttpServletRequest request, PauseResumeForm form) {
        boolean authenticated;
        Credentials credentials = (Credentials)request.getSession().getAttribute("credentials");
        String name = credentials.getName();
        String password = ((GenericPrincipal)credentials.getPrincipal()).getPassword();
        boolean bl = authenticated = name.equalsIgnoreCase(form.getUserName()) && password.equals(form.getPassWord());
        if (!authenticated) {
            log.warn((Object)"User credentials do not match");
        }
        return authenticated;
    }
}

