/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.actions;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.OrParameterMap;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.web.actions.BaseDispatchAction;
import com.tandbergtv.workflow.web.common.StaticCodes;
import com.tandbergtv.workflow.web.formbeans.SearchForm;
import com.tandbergtv.workflow.web.formbeans.WorkOrderDetailsForm;
import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.Page;
import com.tandbergtv.workflow.web.page.PageConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import com.tandbergtv.workflow.web.util.ExportUtility;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkOrderDetailsAction
extends BaseDispatchAction {
    private static final String LIST_SEPERATOR = ",";
    private static String PROCESS_STATUS = "status";
    private static final Logger logger = Logger.getLogger(WorkOrderDetailsAction.class);
    private static String WORKORDER_SEARCH_PAGE = "workOrderSearch";
    private static final String ERROR_MESSAGE_PAUSE = "error.workorderdetails.pause";
    private static final String ERROR_MESSAGE_CANCEL = "error.workorderdetails.cancel";
    private static final String ERROR_MESSAGE_DELETE = "error.workorderdetails.delete";
    private static final String ERROR_MESSAGE_RESTART = "error.workorderdetails.restart";
    private static final String ERROR_MESSAGE_RETRIED = "error.workorderdetails.retry";
    private static final String ERROR_MESSAGE_RESUME = "error.workorderdetails.resume";
    private static final String ERROR_MESSAGE = "error.workorderdetails.message";
    private static final String ERROR_DELETE_MESSAGE = "error.workorderdetails.deletemessage";
    private static final String INFO_MESSAGE = "infoMessages";
    private static final String INFO_ERROR = "errorMessages";
    private static final String CUT_OFF_DURATION = "dashboard.CutOffDuration";
    private Date CUT_OFF_DATE;

    public ActionForward getWorkOrderSearchPage(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchForm form = (SearchForm)actionForm;
        Page page = PageConfig.getInstance().getPage(StaticCodes.WORKORDER_SEARCH_PAGE);
        for (Field field : page.getFields()) {
            form.getSearchData().put(field.getAttribute("name"), "");
            if (field.getAttribute("paramType").equals("list") || field.getAttribute("paramType").equals("range")) {
                String[] vals = new String[]{};
                form.getSearchData().put(field.getAttribute("name"), vals);
                continue;
            }
            form.getSearchData().put(field.getAttribute("name"), "");
        }
        return actionMapping.findForward(WORKORDER_SEARCH_PAGE);
    }

    public ActionForward getWorkOrdersBySearch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IProcessSearchService service = ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
        WorkOrderDetailsForm form = null;
        if ("workOrderDetails".equals(request.getParameter("detailsPage")) || "dashBoard".equals(request.getParameter("sourcePage"))) {
            logger.debug((Object)"The request has come from either DashBoard page or work order details page");
            form = (WorkOrderDetailsForm)actionForm;
        } else {
            logger.debug((Object)"Request has come from the Work Order Search page");
            form = new WorkOrderDetailsForm();
        }
        form.setSourcePage(request.getParameter("sourcePage"));
        SearchCriteria searchCriteria = form.getSearchCriteria();
        if ("workOrderSearch".equals(request.getParameter("sourcePage"))) {
            if ("workOrderDetails".equals(request.getParameter("detailsPage"))) {
                logger.debug((Object)"Request has come from who knows where");
                List<SearchParameterBase> parameters = this.getPreviousSearchCriteria(form);
                for (SearchParameterBase parameter : parameters) {
                    searchCriteria.addParameter(parameter);
                }
            } else {
                logger.debug((Object)"Request has come from the search page");
                HashMap map = new HashMap();
                List<SearchParameterBase> parameters = this.getSearchCriteria(actionForm, map);
                logger.debug((Object)("The Original Search Criteria Object-->" + parameters));
                logger.debug((Object)("The prepared Search Criteria Object-->" + map));
                for (SearchParameterBase parameter : parameters) {
                    searchCriteria.addParameter(parameter);
                }
                form.setFullMap(map);
            }
        } else if ("dashBoard".equals(request.getParameter("sourcePage"))) {
            logger.debug((Object)"Request has come from the Dashboard");
            searchCriteria.addParameter(new ValueParameter(PROCESS_STATUS, SearchType.PROCESSSTATUS, form.getStatus()));
            String tokenStatus = form.getTokenStatus();
            logger.debug((Object)("Token status " + tokenStatus));
            if (tokenStatus != null && tokenStatus.length() > 0) {
                searchCriteria.addParameter(new ValueParameter("tokenstatus", SearchType.PROCESSSTATUS, (Object)ProcessStatus.valueOf(tokenStatus)));
            }
            this.CUT_OFF_DATE = WorkOrderDetailsAction.getCutOffDate();
            if (this.CUT_OFF_DATE != null) {
                this.addCutOffDateParameter(searchCriteria);
            }
        }
        SearchCriteria clone = new SearchCriteria(searchCriteria);
        clone.setStartingRecordNumber(0);
        clone.setRecordsCount(Integer.MAX_VALUE);
        form.setTotalRecords(service.count(clone));
        boolean exportFlag = "export".equals(request.getParameter("exportData"));
        if (exportFlag) {
            searchCriteria.setStartingRecordNumber(0);
            searchCriteria.setRecordsCount(Integer.MAX_VALUE);
        }
        form.setSearchResults(service.search(searchCriteria));
        if (exportFlag) {
            new ExportUtility().exportDataToExcel(request, response, form, form.getWorkOrderDetails());
            return null;
        }
        request.setAttribute("Search_Criteria", (Object)form);
        request.setAttribute("workOrderDetailsForm", (Object)form);
        request.setAttribute("recFound", (Object)form.getTotalRecords());
        logger.debug((Object)"Finished");
        if ("workOrderSearch".equals(request.getParameter("sourcePage")) && form.getTotalRecords() == 0) {
            ActionMessages messages = new ActionMessages();
            messages.add("workOrders.searchResult.noRecords", new ActionMessage("workOrders.searchResult.noRecords", true));
            this.saveMessages(request, messages);
            if (request.getParameter("detailsPage") == null || !request.getParameter("detailsPage").equals("workOrderDetails")) {
                return this.getWorkOrderSearchPage(mapping, actionForm, request, response);
            }
        }
        return mapping.findForward("workOrderSearchResult");
    }

    private List<SearchParameterBase> getSearchCriteria(ActionForm actionForm, HashMap map) throws Exception {
        SearchForm searchForm = (SearchForm)actionForm;
        logger.debug((Object)("Map---->" + searchForm.getSearchData()));
        HashMap<String, Object> searchParamsMap = searchForm.getSearchData();
        Set mapEntries = searchParamsMap.entrySet();
        Page page = PageConfig.getInstance().getPage(WORKORDER_SEARCH_PAGE);
        Field field = null;
        ValueParameter valueParameter = null;
        RangeParameter rangeParameter = null;
        ListParameter listParameter = null;
        ArrayList<SearchParameterBase> searchList = new ArrayList<SearchParameterBase>();
        for (Map.Entry entry : mapEntries) {
            String to;
            field = page.getFieldsMap().get(entry.getKey());
            if (field.getAttribute("paramType").equals("value")) {
                String strEntryValue = entry.getValue() == null ? "" : entry.getValue().toString().trim();
                if (strEntryValue.equals("")) continue;
                if (field.getAttribute("key") == null) {
                    if (field.getAttribute("orList") != null && !field.getAttribute("orList").equals("")) {
                        List<String> varList = WorkOrderDetailsAction.getOrVariableNames(field.getAttribute("orList"));
                        OrParameterMap orMap = new OrParameterMap("OrMap", SearchType.STRING, strEntryValue);
                        for (String varName : varList) {
                            orMap.addParam(varName);
                        }
                        orMap.addParam(field.getAttribute("name"));
                        searchList.add(orMap);
                    } else {
                        valueParameter = new ValueParameter(field.getAttribute("name"));
                        searchList.add(valueParameter);
                    }
                    map.put(field.getAttribute("name"), strEntryValue);
                } else {
                    valueParameter = new ValueParameter(field.getAttribute("key"));
                    searchList.add(valueParameter);
                    map.put(field.getAttribute("name"), strEntryValue);
                }
                if (field.getAttribute("orList") != null && !field.getAttribute("orList").equals("")) continue;
                if (SearchOperator.LIKE.name().equals(field.getAttribute("operator"))) {
                    valueParameter.setFieldType(SearchType.STRING);
                    valueParameter.setOperator(SearchOperator.LIKE);
                } else {
                    valueParameter.setFieldType(SearchType.valueOf(field.getAttribute("dataType")));
                }
                valueParameter.setValue(strEntryValue);
                valueParameter.setVarInstance(Boolean.valueOf(field.getAttribute("dynamic")));
                logger.debug((Object)("Name--->" + field.getAttribute("name") + "-----value--->" + valueParameter.getValue()));
                continue;
            }
            if (field.getAttribute("paramType").equals("list")) {
                String[] entries = (String[])entry.getValue();
                int count = entries.length;
                ArrayList<String> lsEntries = new ArrayList<String>();
                StringBuffer sbValue = new StringBuffer();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        if (entries[i] == null || entries[i].trim().equals("")) continue;
                        lsEntries.add(entries[i].trim());
                        sbValue.append(entries[i]);
                        if (i == count - 1) continue;
                        sbValue.append(LIST_SEPERATOR);
                    }
                }
                if (lsEntries.size() <= 0) continue;
                if (field.getAttribute("key") == null) {
                    listParameter = new ListParameter(field.getAttribute("name"));
                    map.put(field.getAttribute("name"), sbValue.toString());
                } else {
                    listParameter = new ListParameter(field.getAttribute("key"));
                    map.put(field.getAttribute("name"), sbValue.toString());
                }
                listParameter.setValues(lsEntries);
                listParameter.setFieldType(SearchType.valueOf(field.getAttribute("dataType")));
                listParameter.setVarInstance(Boolean.valueOf(field.getAttribute("dynamic")));
                searchList.add(listParameter);
                logger.debug((Object)("Name--->" + field.getAttribute("name") + "-----value--->" + listParameter.getValues()));
                continue;
            }
            if (!field.getAttribute("paramType").equals("range")) continue;
            logger.debug((Object)("name--:" + field.getAttribute("name") + " length:" + ((String[])entry.getValue()).length));
            if (((String[])entry.getValue()).length <= 0) continue;
            String from = ((String[])entry.getValue())[0] == null ? "" : ((String[])entry.getValue())[0].trim();
            String string = to = ((String[])entry.getValue())[1] == null ? "" : ((String[])entry.getValue())[1].trim();
            if ((from == null || from.equals("")) && (to == null || to.equals(""))) continue;
            String strValue = from + LIST_SEPERATOR + to;
            if (field.getAttribute("key") == null) {
                rangeParameter = new RangeParameter(field.getAttribute("name"));
                map.put(field.getAttribute("name"), strValue);
            } else {
                rangeParameter = new RangeParameter(field.getAttribute("key"));
                map.put(field.getAttribute("name"), strValue);
            }
            rangeParameter.setFrom(from);
            rangeParameter.setTo(to);
            rangeParameter.setFieldType(SearchType.valueOf(field.getAttribute("dataType")));
            rangeParameter.setVarInstance(Boolean.valueOf(field.getAttribute("dynamic")));
            searchList.add(rangeParameter);
            logger.debug((Object)("Name--->" + field.getAttribute("name") + "--->Ranges-from---> " + rangeParameter.getFrom() + "--to-" + rangeParameter.getTo()));
        }
        logger.debug((Object)("Search Map-->" + searchList));
        return searchList;
    }

    private List<SearchParameterBase> getPreviousSearchCriteria(WorkOrderDetailsForm detailsForm) throws Exception {
        HashMap searchParamsMap = detailsForm.getFullMap();
        Set mapEntries = searchParamsMap.entrySet();
        Page page = PageConfig.getInstance().getPage(WORKORDER_SEARCH_PAGE);
        Field field = null;
        ValueParameter valueParameter = null;
        RangeParameter rangeParameter = null;
        ListParameter listParameter = null;
        ArrayList<SearchParameterBase> searchList = new ArrayList<SearchParameterBase>();
        for (Map.Entry entry : mapEntries) {
            field = page.getFieldsMap().get(entry.getKey());
            if (field == null) continue;
            if (field.getAttribute("paramType").equals("value")) {
                String strEntryValue = entry.getValue() == null ? "" : entry.getValue().toString().trim();
                if (strEntryValue.equals("")) continue;
                if (field.getAttribute("key") == null) {
                    if (field.getAttribute("orList") != null && !field.getAttribute("orList").equals("")) {
                        List<String> varList = WorkOrderDetailsAction.getOrVariableNames(field.getAttribute("orList"));
                        OrParameterMap orMap = new OrParameterMap("OrMap", SearchType.STRING, strEntryValue);
                        for (String varName : varList) {
                            orMap.addParam(varName);
                        }
                        orMap.addParam(field.getAttribute("name"));
                        searchList.add(orMap);
                    } else {
                        valueParameter = new ValueParameter(field.getAttribute("name"));
                        searchList.add(valueParameter);
                    }
                } else {
                    valueParameter = new ValueParameter(field.getAttribute("key"));
                }
                if (field.getAttribute("orList") != null && !field.getAttribute("orList").equals("")) continue;
                if (SearchOperator.LIKE.name().equals(field.getAttribute("operator"))) {
                    valueParameter.setFieldType(SearchType.STRING);
                    valueParameter.setOperator(SearchOperator.LIKE);
                } else {
                    valueParameter.setFieldType(SearchType.valueOf(field.getAttribute("dataType")));
                }
                valueParameter.setValue(strEntryValue);
                valueParameter.setVarInstance(Boolean.valueOf(field.getAttribute("dynamic")));
                logger.debug((Object)("Name--->" + field.getAttribute("name") + "-----value--->" + valueParameter.getValue()));
                continue;
            }
            if (field.getAttribute("paramType").equals("list")) {
                String values = (String)entry.getValue();
                String[] entries = values.split(LIST_SEPERATOR);
                int count = entries.length;
                ArrayList<String> lsEntries = new ArrayList<String>();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        if (entries[i] == null || entries[i].trim().equals("")) continue;
                        lsEntries.add(entries[i]);
                    }
                }
                if (lsEntries.size() <= 0) continue;
                listParameter = field.getAttribute("key") == null ? new ListParameter(field.getAttribute("name")) : new ListParameter(field.getAttribute("key"));
                listParameter.setValues(lsEntries);
                listParameter.setFieldType(SearchType.valueOf(field.getAttribute("dataType")));
                listParameter.setVarInstance(Boolean.valueOf(field.getAttribute("dynamic")));
                searchList.add(listParameter);
                logger.debug((Object)("Name--->" + field.getAttribute("name") + "-----value--->" + listParameter.getValues()));
                continue;
            }
            if (!field.getAttribute("paramType").equals("range") || ((String)entry.getValue()).trim().equals("")) continue;
            rangeParameter = field.getAttribute("key") == null ? new RangeParameter(field.getAttribute("name")) : new RangeParameter(field.getAttribute(field.getAttribute("key")));
            String[] strParams = ((String)entry.getValue()).trim().split(LIST_SEPERATOR);
            if (!"".equals(strParams[0])) {
                rangeParameter.setFrom(strParams[0]);
            } else {
                rangeParameter.setFrom(null);
            }
            if (strParams.length > 1 && !"".equals(strParams[1])) {
                rangeParameter.setTo(strParams[1]);
            } else {
                rangeParameter.setTo(null);
            }
            rangeParameter.setFieldType(SearchType.valueOf(field.getAttribute("dataType")));
            rangeParameter.setVarInstance(Boolean.valueOf(field.getAttribute("dynamic")));
            searchList.add(rangeParameter);
            logger.debug((Object)("Name--->" + field.getAttribute("name") + "--->Ranges-from---> " + rangeParameter.getFrom() + "--to-" + rangeParameter.getTo()));
        }
        logger.debug((Object)("Search Map-->" + searchList));
        return searchList;
    }

    public ActionForward resumeSelectedWorkOrders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProcessManagerService manager = ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        WorkOrderDetailsForm workOrderDetailsForm = (WorkOrderDetailsForm)form;
        String[] selectedWorkOrders = workOrderDetailsForm.getSelectedWorkOrder();
        logger.debug((Object)("Total number of workorder selected for resume : " + selectedWorkOrders.length));
        ActionMessages messages = new ActionMessages();
        boolean resumed = false;
        ArrayList<WorkflowProcess> processList = new ArrayList<WorkflowProcess>();
        for (int i = 0; i < selectedWorkOrders.length; ++i) {
            processList.add(service.get(Long.valueOf(Long.parseLong(selectedWorkOrders[i]))));
        }
        Collections.sort(processList, new Comparator<WorkflowProcess>(){

            @Override
            public int compare(WorkflowProcess p1, WorkflowProcess p2) {
                if (p1.getPriority() == p2.getPriority()) {
                    return p2.getStart().getTime() > p1.getStart().getTime() ? -1 : (p2.getStart().getTime() == p1.getStart().getTime() ? 0 : 1);
                }
                return p2.getPriority().compareTo(p1.getPriority());
            }
        });
        for (WorkflowProcess process : processList) {
            logger.debug((Object)("RESUMING Work order:" + process));
            CustomToken token = process.getRootToken();
            if (ProcessStatus.PAUSED == token.getStatus()) {
                try {
                    manager.resume(token);
                    resumed = true;
                }
                catch (DriverException e) {
                    logger.error((Object)("Exception while resuming workorder [" + process.getId() + "] " + e.toString()));
                }
                continue;
            }
            logger.debug((Object)("Workorder [" + process.getId() + "] cannot be resumed"));
            messages.add(INFO_ERROR, new ActionMessage(ERROR_MESSAGE_RESUME, (Object)("[" + process.getId() + "]")));
        }
        if (resumed) {
            messages.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)"resume"));
            this.saveMessages(request, messages);
        }
        this.saveErrors(request, messages);
        return this.getWorkOrdersBySearch(mapping, form, request, response);
    }

    public ActionForward pauseSelectedWorkOrders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProcessManagerService manager = ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        WorkOrderDetailsForm workOrderDetailsForm = (WorkOrderDetailsForm)form;
        String[] selectedWorkOrders = workOrderDetailsForm.getSelectedWorkOrder();
        logger.debug((Object)("Total number of workorder selected for pause : " + selectedWorkOrders.length));
        ActionMessages messages = new ActionMessages();
        boolean paused = false;
        for (int i = 0; i < selectedWorkOrders.length; ++i) {
            long workOrderId = Long.parseLong(selectedWorkOrders[i]);
            WorkflowProcess process = service.get(Long.valueOf(workOrderId));
            CustomToken token = process.getRootToken();
            if (process.getCanBePaused()) {
                try {
                    manager.pause(token);
                    paused = true;
                }
                catch (Exception e) {
                    logger.error((Object)("Exception while pausing workorder [" + workOrderId + "] " + e.toString()));
                }
                continue;
            }
            logger.debug((Object)("Workorder [" + workOrderId + "] cannot be paused"));
            messages.add(INFO_ERROR, new ActionMessage(ERROR_MESSAGE_PAUSE, (Object)("[" + workOrderId + "]")));
        }
        if (paused) {
            messages.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)"pause"));
            this.saveMessages(request, messages);
        }
        this.saveErrors(request, messages);
        return this.getWorkOrdersBySearch(mapping, form, request, response);
    }

    public ActionForward cancelSelectedWorkOrders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProcessManagerService manager = ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        WorkOrderDetailsForm workOrderDetailsForm = (WorkOrderDetailsForm)form;
        String[] selectedWorkOrders = workOrderDetailsForm.getSelectedWorkOrder();
        logger.debug((Object)("Total number of workorder selected for cancel : " + selectedWorkOrders.length));
        ActionMessages messages = new ActionMessages();
        boolean cancelled = false;
        for (int i = 0; i < selectedWorkOrders.length; ++i) {
            long workOrderId = Long.parseLong(selectedWorkOrders[i]);
            WorkflowProcess process = service.get(Long.valueOf(workOrderId));
            CustomToken token = process.getRootToken();
            if (process.getCanBeCancelled()) {
                try {
                    manager.cancel(token);
                    cancelled = true;
                }
                catch (Exception e) {
                    logger.error((Object)("Exception while cancelling workorder [" + workOrderId + "] " + e.toString()));
                }
                continue;
            }
            logger.debug((Object)("Workorder [" + workOrderId + "] cannot be cancelled"));
            messages.add(INFO_ERROR, new ActionMessage(ERROR_MESSAGE_CANCEL, (Object)("[" + workOrderId + "]")));
        }
        if (cancelled) {
            messages.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)"cancel"));
            this.saveMessages(request, messages);
        }
        this.saveErrors(request, messages);
        return this.getWorkOrdersBySearch(mapping, form, request, response);
    }

    public ActionForward deleteSelectedWorkOrders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProcessManagerService manager = ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        WorkOrderDetailsForm workOrderDetailsForm = (WorkOrderDetailsForm)form;
        String[] selectedWorkOrders = workOrderDetailsForm.getSelectedWorkOrder();
        logger.debug((Object)("Total number of workorder selected for delete : " + selectedWorkOrders.length));
        ActionMessages messages = new ActionMessages();
        boolean deleted = false;
        for (int i = 0; i < selectedWorkOrders.length; ++i) {
            long workOrderId = Long.parseLong(selectedWorkOrders[i]);
            WorkflowProcess process = service.get(Long.valueOf(workOrderId));
            CustomToken token = process.getRootToken();
            if (ProcessStatus.CANCELLED == token.getStatus() || ProcessStatus.ERROR == token.getStatus() || ProcessStatus.COMPLETED == token.getStatus()) {
                try {
                    manager.delete(process);
                    deleted = true;
                }
                catch (DriverException e) {
                    logger.error((Object)("Exception while deleting workorder [" + workOrderId + "] " + e.toString()));
                }
                continue;
            }
            logger.debug((Object)("Workorder [" + workOrderId + "] cannot be deleted"));
            messages.add(INFO_ERROR, new ActionMessage(ERROR_MESSAGE_DELETE, (Object)("[" + workOrderId + "]")));
        }
        if (deleted) {
            messages.add(INFO_MESSAGE, new ActionMessage(ERROR_DELETE_MESSAGE, (Object)"delete"));
            this.saveMessages(request, messages);
        }
        this.saveErrors(request, messages);
        return this.getWorkOrdersBySearch(mapping, form, request, response);
    }

    public ActionForward restartSelectedWorkOrders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProcessManagerService manager = ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        WorkOrderDetailsForm workOrderDetailsForm = (WorkOrderDetailsForm)form;
        String[] selectedWorkOrders = workOrderDetailsForm.getSelectedWorkOrder();
        logger.debug((Object)("Total number of workorder selected for restart : " + selectedWorkOrders.length));
        ActionMessages messages = new ActionMessages();
        boolean restarted = false;
        for (int i = 0; i < selectedWorkOrders.length; ++i) {
            long workOrderId = Long.parseLong(selectedWorkOrders[i]);
            WorkflowProcess process = service.get(Long.valueOf(workOrderId));
            if (process.getCanBeRestarted()) {
                try {
                    manager.restart(Long.valueOf(process.getId()));
                    restarted = true;
                }
                catch (DriverException e) {
                    logger.error((Object)("Exception while restarting workorder [" + workOrderId + "] " + e.toString()));
                }
                continue;
            }
            log.debug((Object)("Workorder [" + workOrderId + "] cannot be restarted"));
            messages.add(INFO_ERROR, new ActionMessage(ERROR_MESSAGE_RESTART, (Object)("[" + workOrderId + "]")));
        }
        if (restarted) {
            messages.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)"restart"));
            this.saveMessages(request, messages);
        }
        this.saveErrors(request, messages);
        return this.getWorkOrdersBySearch(mapping, form, request, response);
    }

    public ActionForward retrySelectedWorkOrders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPersistenceService service = ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        IProcessManagerService manager = ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        WorkOrderDetailsForm workOrderDetailsForm = (WorkOrderDetailsForm)form;
        String[] selectedWorkOrders = workOrderDetailsForm.getSelectedWorkOrder();
        logger.debug((Object)("Total number of workorder selected for retry : " + selectedWorkOrders.length));
        ActionMessages messages = new ActionMessages();
        boolean retried = false;
        for (int i = 0; i < selectedWorkOrders.length; ++i) {
            long workOrderId = Long.parseLong(selectedWorkOrders[i]);
            WorkflowProcess process = service.get(Long.valueOf(workOrderId));
            CustomToken token = process.getRootToken();
            if (process.getCanBeRetried()) {
                try {
                    manager.resume(token);
                    retried = true;
                }
                catch (DriverException e) {
                    logger.error((Object)("Exception while restarting workorder [" + workOrderId + "] " + e.toString()));
                }
                continue;
            }
            logger.debug((Object)("Workorder [" + workOrderId + "] cannot be restarted"));
            messages.add(INFO_ERROR, new ActionMessage(ERROR_MESSAGE_RETRIED, (Object)("[" + workOrderId + "]")));
        }
        if (retried) {
            messages.add(INFO_MESSAGE, new ActionMessage(ERROR_MESSAGE, (Object)"retry"));
            this.saveMessages(request, messages);
        }
        this.saveErrors(request, messages);
        return this.getWorkOrdersBySearch(mapping, form, request, response);
    }

    private static Date getCutOffDate() {
        Date cutOffDate = null;
        int cutOffDuration = 0;
        ResourceBundle bundle = CommonUtils.getApplicationUIResourceBundle();
        try {
            cutOffDuration = Integer.parseInt(bundle.getString(CUT_OFF_DURATION));
            GregorianCalendar gregCal = new GregorianCalendar();
            gregCal.setTime(new Date());
            gregCal.add(5, -1 * cutOffDuration);
            cutOffDate = gregCal.getTime();
        }
        catch (Exception e) {
            logger.debug((Object)("Could not evaluate cut off date from duration " + cutOffDuration));
        }
        return cutOffDate;
    }

    private void addCutOffDateParameter(SearchCriteria criteria) {
        String date = new SimpleDateFormat("yyyy-MM-dd").format(this.CUT_OFF_DATE);
        RangeParameter rangeParam = new RangeParameter("start", SearchType.DATE, false);
        rangeParam.setFrom(date);
        criteria.addParameter(rangeParam);
    }

    private static List<String> getOrVariableNames(String orVars) {
        String[] idList = (orVars = orVars == null ? "" : orVars.trim()).split(LIST_SEPERATOR);
        List<String> result = Arrays.asList(idList);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result;
    }
}

