/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.entities;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUsageDisplay
implements Serializable {
    private static final long serialVersionUID = -414119907344679794L;
    private String resourceName;
    private String resourceId;
    private String workOrderId;
    private String tokenId;
    private String processStatus;
    private String processAdminStatus;
    private String progressStatus;
    private Map<String, Object> workOrderParameters;
    private static final Logger logger = Logger.getLogger(ResourceUsageDisplay.class);
    private static final String NULL_PARAMETER_VALUE = "null";
    private static final String MISSING_PARAMETER_VALUE = "";

    public ResourceUsageDisplay() {
    }

    public ResourceUsageDisplay(Resource resource, CustomToken token) {
        this.resourceName = resource.getName();
        this.resourceId = Long.toString(resource.getId());
        WorkflowProcess process = token.getProcessInstance();
        this.workOrderParameters = new HashMap<String, Object>();
        this.workOrderParameters.putAll(process.getContextInstance().getVariables());
        this.workOrderId = Long.toString(process.getId());
        this.tokenId = Long.toString(token.getId());
        this.processStatus = token.getStatus().toString();
        this.processAdminStatus = token.getRequestedStatus().toString();
    }

    public String getProgressStatus() {
        if (this.progressStatus == null) {
            return "0";
        }
        return this.progressStatus;
    }

    public void setProgressStatus(String progressStatus) {
        this.progressStatus = progressStatus;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getWorkOrderId() {
        return this.workOrderId;
    }

    public void setWorkOrderId(String workOrderId) {
        this.workOrderId = workOrderId;
    }

    public Map<String, Object> getWorkOrderParameters() {
        return this.workOrderParameters;
    }

    public String getProcessAdminStatus() {
        return this.processAdminStatus;
    }

    public void setProcessAdminStatus(String processAdminStatus) {
        this.processAdminStatus = processAdminStatus;
    }

    public String getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(String processStatus) {
        this.processStatus = processStatus;
    }

    public void setWorkOrderParameters(Map<String, Object> workOrderParameters) {
        this.workOrderParameters = workOrderParameters;
    }

    public int getProgressStatusValue() {
        int progressPercent = 0;
        if (this.progressStatus != null && this.progressStatus.trim().length() > 0) {
            try {
                progressPercent = Integer.parseInt(this.progressStatus);
            }
            catch (NumberFormatException nfe) {
                String msg = "The Progress Percentage is not a valid integer value, setting value to 0.";
                logger.warn((Object)msg, (Throwable)nfe);
            }
        }
        return progressPercent;
    }

    public String getParameterValue(String key) {
        String value = MISSING_PARAMETER_VALUE;
        if (this.workOrderParameters != null) {
            Object paramValue = this.workOrderParameters.get(key);
            if (this.workOrderParameters.containsKey(key) && paramValue == null) {
                value = NULL_PARAMETER_VALUE;
            } else if (paramValue != null) {
                value = paramValue.toString();
            }
        }
        return value;
    }
}

