/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.formbeans;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.DurationAware;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.web.formbeans.PaginationAndSortingForm;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import com.tandbergtv.workflow.web.util.CommonUtils;
import com.tandbergtv.workflow.web.util.ProcessInfo;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkOrderTaskForm
extends PaginationAndSortingForm {
    private static final String ZERO_PERCENT = "0";
    private static final String HUNDRED_PERCENT = "100";
    private static final String TABLE_ID = "WorkOrderTasksHistory";
    private static final long serialVersionUID = 1L;
    private String workOrderNo;
    private String workOrderOptStatus;
    private String workOrderAdminStatus;
    private String taskName;
    private String taskStatus;
    private String taskStartTime;
    private String taskEndTime;
    private String defaultTaskImage;
    private String duration = null;
    private long nodeId;
    private boolean isVisited;
    private String nodeOperationalStatus;
    private WorkflowProcess process;
    private Map parameters;
    private Node node;
    private Token token;
    private String resourceGroupName;
    private long currentTaskMessagesKey = -1L;
    private long historyTaskMessagesKey = -1L;
    private Table table;
    private int depth;
    private String branchName;
    private Set<String> loopNames;
    private String allLoopNames;

    public WorkOrderTaskForm() {
        this.setTable(TABLE_ID);
    }

    public WorkOrderTaskForm(Node node) {
        this.setNode(node);
    }

    public WorkOrderTaskForm(Node node, Token token) {
        this(node);
        this.setToken(token);
    }

    public String getDuration() {
        return this.duration == null ? "-NA-" : this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getWorkOrderNo() {
        return this.workOrderNo;
    }

    public void setWorkOrderNo(String workOrderNo) {
        this.workOrderNo = workOrderNo;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getWorkOrderAdminStatus() {
        return this.workOrderAdminStatus;
    }

    public void setWorkOrderAdminStatus(String workOrderAdminStatus) {
        this.workOrderAdminStatus = workOrderAdminStatus;
    }

    public String getWorkOrderOptStatus() {
        return this.workOrderOptStatus;
    }

    public void setWorkOrderOptStatus(String workOrderOptStatus) {
        this.workOrderOptStatus = workOrderOptStatus;
    }

    public String getTaskEndTime() {
        return this.taskEndTime;
    }

    public void setTaskEndTime(String taskEndTime) {
        this.taskEndTime = taskEndTime;
    }

    public String getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(String taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public String getDefaultTaskImage() {
        return this.defaultTaskImage;
    }

    public void setStartDate(Date start) {
        this.setTaskStartTime(CommonUtils.formatTime(start));
    }

    public void setEndDate(Date end) {
        this.setTaskEndTime(CommonUtils.formatTime(end));
    }

    public void setDefaultTaskImage(String defaultTaskImage) {
        this.defaultTaskImage = defaultTaskImage;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public boolean getVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public String getNodeOperationalStatus() {
        return this.nodeOperationalStatus;
    }

    public void setNodeOperationalStatus(String nodeOperationalStatus) {
        this.nodeOperationalStatus = nodeOperationalStatus;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    public void setProcess(WorkflowProcess process) {
        this.process = process;
        this.setWorkOrderOptStatus(process.getRootToken().getStatus().toString());
        this.setWorkOrderAdminStatus(process.getRootToken().getRequestedStatus().toString());
        this.setParameters(ProcessInfo.getVariablesToShowInUI(process));
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public Node getNode() {
        return this.node;
    }

    private void setNode(Node node) {
        this.node = node;
        this.nodeId = node.getId();
        this.taskName = node.getName();
        String className = node.getClass().getName();
        this.defaultTaskImage = "image" + className.substring(className.lastIndexOf("."));
        if (node instanceof DurationAware) {
            this.duration = ((DurationAware)node).getTaskDuration();
        }
    }

    private void setToken(Token token) {
        this.token = token;
        this.setTimestamps();
        this.setStatus();
        this.setPercentComplete();
    }

    public Token getToken() {
        return this.token;
    }

    private void setTimestamps() {
        if (this.node instanceof StartState) {
            this.taskStartTime = CommonUtils.formatTime(this.token.getProcessInstance().getStart());
        } else if (this.node instanceof EndState && this.token.getProcessInstance().hasEnded()) {
            this.taskStartTime = this.taskEndTime = CommonUtils.formatTime(this.token.getProcessInstance().getEnd());
        }
    }

    private void setStatus() {
        if (this.node instanceof StartState) {
            this.nodeOperationalStatus = ProcessStatus.COMPLETED.toString();
        } else if (this.node instanceof EndState && this.token.getProcessInstance().hasEnded()) {
            this.nodeOperationalStatus = ((CustomToken)this.token).getStatus().toString();
        }
    }

    private void setPercentComplete() {
        this.taskStatus = this.node instanceof StartState ? HUNDRED_PERCENT : (this.node instanceof EndState && this.token.getProcessInstance().hasEnded() ? HUNDRED_PERCENT : ZERO_PERCENT);
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public void setResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
    }

    public String getTemplateName() {
        if (this.process != null) {
            return this.process.getProcessDefinition().getFullName();
        }
        return "";
    }

    public long getCurrentTaskMessagesKey() {
        return this.currentTaskMessagesKey;
    }

    public void setCurrentTaskMessagesKey(long messageLogsKey) {
        this.currentTaskMessagesKey = messageLogsKey;
    }

    public String toString() {
        String str = this.getTaskName() + " | " + this.getResourceGroupName() + " | " + this.getTaskStartTime() + " | " + this.getTaskEndTime();
        return str;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    protected void setTable(String tableId) {
        this.table = TableConfig.getInstance().getTable(tableId);
    }

    public long getHistoryTaskMessagesKey() {
        return this.historyTaskMessagesKey;
    }

    public void setHistoryTaskMessagesKey(long jbpmNodeLongID) {
        this.historyTaskMessagesKey = jbpmNodeLongID;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public Set<String> getLoopNames() {
        return this.loopNames;
    }

    public void setLoopNames(Set<String> loopNames) {
        this.loopNames = loopNames;
    }

    public void addLoopName(String loopName) {
        if (this.loopNames == null) {
            this.loopNames = new HashSet<String>();
        }
        this.loopNames.add(loopName);
    }

    public String getAllLoopNames() {
        this.allLoopNames = "";
        String comma = "";
        if (this.loopNames != null) {
            for (String loopName : this.loopNames) {
                this.allLoopNames = loopName + comma + this.allLoopNames;
                comma = ", ";
            }
        }
        return this.allLoopNames;
    }

    public void setAllLoopNames(String allLoopNames) {
        this.allLoopNames = allLoopNames;
    }
}

