/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.menu.displayer;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkFlowMenuDisplayer
extends MessageResourcesMenuDisplayer {
    private static final Logger log = Logger.getLogger(WorkFlowMenuDisplayer.class);
    protected static final String nbsp = "&nbsp;";
    private ArrayList<MenuComponent> menuCmptList;
    static String DISPLAY_MAINMENU_BEGIN = "tmd.menu.mainmenu.begin";
    static String DISPLAY_MAINMENU_END = "tmd.menu.mainmenu.end";
    static String DISPLAY_SUBMENU_ONE_BEGIN = "tmd.menu.submenu.one.begin";
    static String DISPLAY_SUBMENU_ONE_END = "tmd.menu.submenu.one.end";
    static String DISPLAY_IMAGE = "tmd.menu.image";
    static String DISPLAY_LINK_A = "tmd.menu.link";
    static String DISPLAY_COLOUM = "tmd.menu.column";

    public void init(PageContext pageContext, MenuDisplayerMapping mapping) {
        super.init(pageContext, mapping);
        HttpSession session = pageContext.getSession();
        String tabselected = (String)session.getAttribute("tabselect");
        try {
            this.menuCmptList = new ArrayList();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    public void display(MenuComponent menu) throws JspException, IOException {
        if (this.isAllowed(menu)) {
            this.menuCmptList.add(menu);
        }
    }

    public void end(PageContext context) {
        try {
            this.displayMenu(this.menuCmptList);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    protected void displayMenu(ArrayList menuCmptList) throws JspException, IOException {
        if (menuCmptList != null && menuCmptList.size() > 0) {
            int i;
            ArrayList<StringBuffer> rowList = new ArrayList<StringBuffer>();
            for (i = 0; i < menuCmptList.size(); ++i) {
                MenuComponent menuCmpt = (MenuComponent)menuCmptList.get(i);
                this.displayComponents(menuCmpt, rowList, 0);
            }
            for (i = 0; i < rowList.size(); ++i) {
                StringBuffer strBuf = (StringBuffer)rowList.get(i);
                if (i == 0) {
                    this.out.print(this.displayStrings.getMessage(DISPLAY_MAINMENU_BEGIN));
                } else if (i == 1) {
                    this.out.print(this.displayStrings.getMessage(DISPLAY_SUBMENU_ONE_BEGIN));
                }
                this.out.print(strBuf.toString());
                if (i == 0) {
                    this.out.print(this.displayStrings.getMessage(DISPLAY_MAINMENU_END));
                    continue;
                }
                if (i != 1) continue;
                this.out.print(this.displayStrings.getMessage(DISPLAY_SUBMENU_ONE_END));
            }
        }
    }

    protected boolean displayComponents(MenuComponent menuCmpt, ArrayList<StringBuffer> rowList, int level) throws JspException, IOException {
        boolean isMenuSelected = false;
        if (menuCmpt.checkMenuSelected(super.getSelectedmenu())) {
            isMenuSelected = true;
        }
        MenuComponent[] components = menuCmpt.getMenuComponents();
        if (rowList.size() <= level) {
            rowList.add(level, new StringBuffer());
        }
        StringBuffer strBuf = rowList.get(level);
        if (components.length > 0 && isMenuSelected) {
            if (menuCmpt.getUrl() == null) {
                menuCmpt.setUrl(components[0].getUrl());
            }
            for (int i = 0; i < components.length; ++i) {
                boolean stickyValue;
                if (!this.isAllowed(components[i]) || !(stickyValue = this.displayComponents(components[i], rowList, level + 1))) continue;
                isMenuSelected = true;
            }
            strBuf.append(this.displayStrings.getMessage(DISPLAY_COLOUM, (Object)this.getLinkA(menuCmpt), (Object)this.getImage(menuCmpt, isMenuSelected)));
        } else {
            strBuf.append(this.displayStrings.getMessage(DISPLAY_COLOUM, (Object)this.getLinkA(menuCmpt), (Object)this.getImage(menuCmpt, isMenuSelected)));
        }
        return isMenuSelected;
    }

    protected String getImage(MenuComponent menu, boolean isMenuSelected) {
        String imageTag = menu.getImage() == null || menu.getImage().equals("") ? "" : (isMenuSelected ? this.displayStrings.getMessage(DISPLAY_IMAGE, (Object)menu.getAltImage(), (Object)menu.getName(), (Object)menu.getToolTip()) : this.displayStrings.getMessage(DISPLAY_IMAGE, (Object)menu.getImage(), (Object)menu.getName(), (Object)menu.getToolTip()));
        return imageTag;
    }

    protected String getLinkA(MenuComponent menu) {
        String linkTag = menu.getName() == null || menu.getName().equals("") ? "" : this.displayStrings.getMessage(DISPLAY_LINK_A, (Object)menu.getUrl(), (Object)menu.getName(), (Object)menu.getOnmouseover(), (Object)menu.getToolTip());
        return linkTag;
    }
}

