/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.report;

import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.web.report.Report;
import com.tandbergtv.workflow.web.report.ReportCategory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportConfig {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ReportConfig.class);
    private static final String REPORT_CONFIG_FILE_NAME = "report-config.xml";
    private static final String REPORT_CATEGORY = "reportCategory";
    private static final String REPORT_CATEGORY_NAME = "name";
    private static final String REPORT_TITLE = "title";
    private static final String REPORT_NAME = "reportName";
    private static final String REPORT_CATALOG_NAME = "catalogName";
    private static final String REPORTS_URL = "url";
    private static final String REPORT_VERSION = "reportVersion";
    private static ReportConfig _reportConfig = null;
    private List<ReportCategory> reportCategories = new ArrayList<ReportCategory>();
    private String reportsURL = "";

    private ReportConfig() throws Exception {
        this.readReportConfig();
        logger.debug((Object)("URL: " + this.reportsURL));
        this.print(this.reportCategories);
    }

    public static synchronized ReportConfig getStaticInstance() throws Exception {
        if (_reportConfig == null) {
            _reportConfig = new ReportConfig();
        }
        return _reportConfig;
    }

    public String getReportsURL() {
        return this.reportsURL;
    }

    public List<ReportCategory> getReportCategories() {
        return this.reportCategories;
    }

    private void readReportConfig() throws Exception {
        String dir = ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath");
        String filename = dir + System.getProperty("file.separator") + REPORT_CONFIG_FILE_NAME;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(filename));
        Element element = doc.getDocumentElement();
        this.reportsURL = element.getAttribute(REPORTS_URL);
        NodeList rptCatNodeList = element.getElementsByTagName(REPORT_CATEGORY);
        for (int i = 0; i < rptCatNodeList.getLength(); ++i) {
            Node currentRptCatNode = rptCatNodeList.item(i);
            ReportCategory reportCategory = new ReportCategory();
            reportCategory.setName(currentRptCatNode.getAttributes().getNamedItem(REPORT_CATEGORY_NAME).getNodeValue());
            if (!currentRptCatNode.hasChildNodes()) continue;
            ArrayList<Report> reports = new ArrayList<Report>();
            NodeList reportNodeList = currentRptCatNode.getChildNodes();
            for (int j = 0; j < reportNodeList.getLength(); ++j) {
                Node currentReportNode = reportNodeList.item(j);
                if (!currentReportNode.hasChildNodes()) continue;
                Report report = new Report();
                NodeList reportChildNodeList = currentReportNode.getChildNodes();
                for (int k = 0; k < reportChildNodeList.getLength(); ++k) {
                    Node currentReportChildNode = reportChildNodeList.item(k);
                    if (currentReportChildNode.getNodeType() != 1) continue;
                    String nodeName = currentReportChildNode.getNodeName();
                    String value = currentReportChildNode.getFirstChild().getNodeValue();
                    if (nodeName.equalsIgnoreCase(REPORT_TITLE)) {
                        report.setTitle(value);
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(REPORT_CATALOG_NAME)) {
                        report.setCatalogName(value);
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(REPORT_NAME)) {
                        report.setReportName(value);
                        continue;
                    }
                    if (!nodeName.equalsIgnoreCase(REPORT_VERSION)) continue;
                    report.setReportVersion(value);
                }
                reports.add(report);
            }
            reportCategory.setReports(reports);
            this.reportCategories.add(reportCategory);
        }
    }

    private void print(List<ReportCategory> reportCategories) {
        for (int i = 0; i < reportCategories.size(); ++i) {
            ReportCategory reportCategory = reportCategories.get(i);
            logger.debug((Object)("Category Name: " + reportCategory.getName()));
            List<Report> reports = reportCategory.getReports();
            for (int j = 0; j < reports.size(); ++j) {
                Report report = reports.get(j);
                logger.debug((Object)("\tTitle: " + report.getTitle()));
                logger.debug((Object)("\tCatalog Name: " + report.getCatalogName()));
                logger.debug((Object)("\tReport Name: " + report.getReportName()));
                logger.debug((Object)("\tReport Version: " + report.getReportVersion()));
                logger.debug((Object)"");
            }
            logger.debug((Object)"");
        }
    }
}

