/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.web.formbeans.WorkOrderTaskForm;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNodePainter
implements NodeVisitor {
    private static final Logger logger = Logger.getLogger(BasicNodePainter.class);
    protected List<WorkOrderTaskForm> forms = new ArrayList<WorkOrderTaskForm>();

    protected BasicNodePainter() {
    }

    public BasicNodePainter(List<WorkOrderTaskForm> forms) {
        this.forms = forms;
    }

    @Override
    public void visit(Node node) {
        WorkOrderTaskForm form;
        Node tempNode = node;
        if (node.getSuperState() != null) {
            tempNode = node.getSuperState();
        }
        if (!this.forms.contains((Object)(form = new WorkOrderTaskForm(tempNode)))) {
            this.setResourceGroup(form, tempNode);
            this.add(form);
        }
    }

    protected void setResourceGroup(WorkOrderTaskForm form, Node node) {
        if (node instanceof ResourceGroupAware) {
            ResourceGroupAware aware = (ResourceGroupAware)node;
            ResourceGroup group = null;
            if (aware.getResourceGroupID() != null) {
                try {
                    group = ResourceManager.getInstance().getResourceGroup(aware.getResourceGroupID());
                }
                catch (FinderException e) {
                    logger.warn((Object)("Exception in finding resource group for id: " + aware.getResourceGroupID()), (Throwable)e);
                }
                if (group != null) {
                    logger.debug((Object)("Resource Group Name: " + group.getName()));
                    form.setResourceGroupName(group.getName());
                }
            }
        }
    }

    protected void add(WorkOrderTaskForm form) {
        Node node = form.getNode();
        int lastIndex = this.forms.size() - 1;
        if (node instanceof StartState) {
            this.forms.add(0, form);
        } else if (node instanceof EndState) {
            this.forms.add(form);
        } else if (this.forms.get(lastIndex).getNode() instanceof EndState) {
            this.forms.add(lastIndex, form);
        } else {
            this.forms.add(form);
        }
    }
}

