/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.web.formbeans.WorkOrderTaskForm;
import com.tandbergtv.workflow.web.util.BasicNodePainter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.Join;
import org.jbpm.graph.node.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchAndLoopNodePainter
extends BasicNodePainter {
    private static final Logger logger = Logger.getLogger(BranchAndLoopNodePainter.class);
    private List<WorkOrderTaskForm> orderedForms;
    private Map<Node, WorkOrderTaskForm> formsMap = new HashMap<Node, WorkOrderTaskForm>();
    private Map<Integer, Node> indexNode = new HashMap<Integer, Node>();
    private Map<Node, Integer> nodeIndex = new HashMap<Node, Integer>();
    private int[][] adjacencyMatrix;
    private int numberOfNodes;
    private Map<Node, Integer> maxPath = new HashMap<Node, Integer>();

    public BranchAndLoopNodePainter(List<WorkOrderTaskForm> forms) {
        this.orderedForms = forms;
    }

    public void addLoopInfo(String loopNames, List<Node> nodeList) {
        String loopName = this.extractSingleLoopName(loopNames, nodeList);
        if (loopName != null) {
            for (WorkOrderTaskForm form : this.forms) {
                if (!nodeList.contains(form.getNode())) continue;
                form.addLoopName(loopName);
                logger.debug((Object)("added loopName " + loopName + " to node " + form.getNode().getName()));
            }
        }
    }

    private String extractSingleLoopName(String loopNames, List<Node> nodeList) {
        String loopName = null;
        int maxDistance = -1;
        Node farthestNode = null;
        HashSet<String> setOfBranchNames = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(loopNames, ",");
        if (st.countTokens() > 0) {
            while (st.hasMoreTokens()) {
                String item = st.nextToken();
                setOfBranchNames.add(item);
            }
        }
        for (Node node : nodeList) {
            int distance = this.maxPath.get(node);
            if (distance <= maxDistance) continue;
            maxDistance = distance;
            farthestNode = node;
        }
        List transitions = farthestNode.getLeavingTransitions();
        for (Transition t : transitions) {
            if (!setOfBranchNames.contains(t.getName())) continue;
            loopName = t.getName();
        }
        return loopName;
    }

    @Override
    protected void add(WorkOrderTaskForm form) {
        Node node = form.getNode();
        int lastIndex = this.forms.size() - 1;
        if (node instanceof StartState) {
            this.forms.add(0, form);
            this.formsMap.put(node, form);
        } else if (node instanceof EndState) {
            this.forms.add(form);
            this.formsMap.put(node, form);
        } else if (((WorkOrderTaskForm)((Object)this.forms.get(lastIndex))).getNode() instanceof EndState) {
            this.forms.add(lastIndex, form);
            this.formsMap.put(node, form);
        } else {
            this.forms.add(form);
            this.formsMap.put(node, form);
        }
    }

    public void reorderTheForms(Map<Node, List<Node>> reachables) {
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        WorkOrderTaskForm startForm = (WorkOrderTaskForm)((Object)this.forms.get(0));
        Node startNode = startForm.getNode();
        WorkOrderTaskForm endForm = (WorkOrderTaskForm)((Object)this.forms.get(this.forms.size() - 1));
        Node endNode = endForm.getNode();
        Node currentNode = startNode;
        this.processNode(currentNode, reachables, this.orderedForms, traversed, "");
        this.orderedForms.add(endForm);
        this.setBranchName(endNode, "");
    }

    private void processNode(Node currentNode, Map<Node, List<Node>> adjacencyMap, List<WorkOrderTaskForm> orderedForms, Map<Node, Boolean> traversed, String brName) {
        Boolean visited = traversed.get(currentNode);
        if (currentNode instanceof EndState || currentNode instanceof Join || visited != null) {
            return;
        }
        logger.debug((Object)("processing: " + currentNode.getName()));
        traversed.put(currentNode, true);
        orderedForms.add(this.formsMap.get(currentNode));
        List<Node> nextNodes = adjacencyMap.get(currentNode);
        if (nextNodes.size() == 1) {
            currentNode = nextNodes.get(0);
            if (currentNode instanceof Join || currentNode instanceof EndState) {
                this.setBranchName(currentNode, "");
                this.processNode(currentNode, adjacencyMap, orderedForms, traversed, "");
            } else {
                this.setBranchName(currentNode, brName);
                this.processNode(currentNode, adjacencyMap, orderedForms, traversed, brName);
            }
        } else if (currentNode instanceof Fork) {
            Node joinNode = null;
            for (Node nodeIter : nextNodes) {
                Set arrivingTransitions = nodeIter.getArrivingTransitions();
                String branchName = "";
                for (Transition t : arrivingTransitions) {
                    branchName = t.getName();
                }
                currentNode = nodeIter;
                this.setBranchName(currentNode, branchName);
                List<Node> nextBranchNodes = adjacencyMap.get(currentNode);
                while (!(currentNode instanceof Join) && !(currentNode instanceof Decision)) {
                    orderedForms.add(this.formsMap.get(currentNode));
                    traversed.put(currentNode, true);
                    currentNode = nextBranchNodes.get(0);
                    this.setBranchName(currentNode, branchName);
                }
                if (currentNode instanceof Decision) {
                    orderedForms.add(this.formsMap.get(currentNode));
                    traversed.put(currentNode, true);
                    currentNode = nextBranchNodes.get(0);
                    if (currentNode instanceof Join) {
                        joinNode = currentNode;
                    } else {
                        this.setBranchName(currentNode, branchName);
                        this.processNode(currentNode, adjacencyMap, orderedForms, traversed, branchName);
                    }
                    currentNode = nextBranchNodes.get(1);
                    if (currentNode instanceof Join) {
                        joinNode = currentNode;
                        continue;
                    }
                    this.setBranchName(currentNode, branchName);
                    this.processNode(currentNode, adjacencyMap, orderedForms, traversed, branchName);
                    continue;
                }
                if (!(currentNode instanceof Join)) continue;
                joinNode = currentNode;
            }
            orderedForms.add(this.formsMap.get(joinNode));
            traversed.put(joinNode, true);
            this.setBranchName(joinNode, "");
            List<Node> nextNodeFromJoin = adjacencyMap.get(joinNode);
            currentNode = nextNodeFromJoin.get(0);
            this.processNode(currentNode, adjacencyMap, orderedForms, traversed, "");
        } else if (currentNode instanceof Decision) {
            currentNode = nextNodes.get(0);
            this.setBranchName(currentNode, brName);
            this.processNode(currentNode, adjacencyMap, orderedForms, traversed, brName);
            currentNode = nextNodes.get(1);
            this.setBranchName(currentNode, brName);
            this.processNode(currentNode, adjacencyMap, orderedForms, traversed, brName);
        }
    }

    private void setBranchName(Node currentNode, String branchName) {
        WorkOrderTaskForm form = this.formsMap.get(currentNode);
        form.setBranchName(branchName);
        if (!branchName.equals("")) {
            form.setDepth(1);
        }
    }

    public void findLongestPaths() {
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        HashMap<Node, Boolean> valueSet = new HashMap<Node, Boolean>();
        WorkOrderTaskForm endForm = (WorkOrderTaskForm)((Object)this.forms.get(this.forms.size() - 1));
        Node endNode = endForm.getNode();
        this.findMaxPath(endNode, traversed, valueSet);
    }

    private int findMaxPath(Node node, Map<Node, Boolean> traversed, Map<Node, Boolean> valueSet) {
        logger.debug((Object)node.getName());
        traversed.put(node, true);
        int index = this.nodeIndex.get(node);
        int maxValue = -1;
        if (valueSet.containsKey(node)) {
            return this.maxPath.get(node);
        }
        for (int i = 0; i < this.numberOfNodes; ++i) {
            int result;
            if (this.adjacencyMatrix[i][index] == 0) continue;
            Boolean visited = traversed.get(this.indexNode.get(i));
            if (visited == null || !visited.booleanValue()) {
                HashMap<Node, Boolean> clonedTraversed = new HashMap<Node, Boolean>();
                clonedTraversed.putAll(traversed);
                result = this.findMaxPath(this.indexNode.get(i), clonedTraversed, valueSet);
                if (result <= maxValue) continue;
                maxValue = result;
                continue;
            }
            result = -1;
        }
        if (maxValue != -1) {
            ++maxValue;
        }
        boolean hasIncoming = false;
        for (int i = 0; i < this.numberOfNodes; ++i) {
            if (this.adjacencyMatrix[i][index] == 0) continue;
            hasIncoming = true;
            break;
        }
        if (!hasIncoming) {
            maxValue = 0;
        }
        if (maxValue != -1) {
            valueSet.put(node, true);
            this.maxPath.put(node, maxValue);
            logger.debug((Object)("maxPath for " + node.getName() + " is " + maxValue));
        }
        return maxValue;
    }

    public void populateAdjacencyMatrix(Map<Node, List<Node>> adjacencyMap) {
        Set<Node> nodeSet = adjacencyMap.keySet();
        this.numberOfNodes = nodeSet.size();
        this.adjacencyMatrix = new int[this.numberOfNodes][this.numberOfNodes];
        for (int i = 0; i < this.numberOfNodes; ++i) {
            for (int j = 0; j < this.numberOfNodes; ++j) {
                this.adjacencyMatrix[i][j] = 0;
            }
        }
        int index = 0;
        for (Node node : nodeSet) {
            this.indexNode.put(index, node);
            this.nodeIndex.put(node, index);
            logger.debug((Object)("put " + node.getName() + " with index " + index));
            ++index;
        }
        for (Node nodeI : nodeSet) {
            int indexI = this.nodeIndex.get(nodeI);
            List<Node> reachableNodes = adjacencyMap.get(nodeI);
            if (reachableNodes == null) continue;
            for (Node nodeJ : reachableNodes) {
                int indexJ = this.nodeIndex.get(nodeJ);
                this.adjacencyMatrix[indexI][indexJ] = 1;
                logger.debug((Object)("Edge from " + nodeI.getName() + " to " + nodeJ.getName()));
            }
        }
    }
}

