/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.n2bb.web.util.ReportWriter;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExportUtility {
    public String outputType = null;
    public String header = "Default";
    public String[][] filterBy = null;
    public String sortBy = null;
    public Collection records = null;
    public String[] columnDisplayNames = null;
    public String[] columnNames = null;
    public String[] parameterNames = null;
    private static final Logger log = Logger.getLogger(ExportUtility.class);
    private static String FILE_NAME = "WorkFlowMessageResources";

    public boolean exportDataToExcel(HttpServletRequest request, HttpServletResponse response, BaseForm baseForm, Collection dataBeans) {
        boolean executionStatus = true;
        try {
            this.outputType = "Excel";
            this.header = request.getParameter("headerName") == null ? this.header : request.getParameter("headerName").toString();
            log.debug((Object)("Header Name:" + this.header));
            this.sortBy = baseForm.getSortingColumnName() == null || baseForm.getSortingColumnName().equals("") ? null : baseForm.getSortingColumnName();
            log.debug((Object)("Sort By:" + this.sortBy));
            this.records = dataBeans;
            log.debug((Object)("records :" + this.records));
            String tableName = request.getParameter("tableName") == null ? "NO TABLE FOUND" : request.getParameter("tableName").toString();
            Table table = TableConfig.getInstance().getTable(tableName);
            Collection<Column> columnCollections = table.getColumns();
            int index = 0;
            ArrayList<String> columnDisplayNamesList = new ArrayList<String>();
            ArrayList<String> columnNamesList = new ArrayList<String>();
            ArrayList<String> parameterList = new ArrayList<String>();
            ResourceBundle rbPaginationConstants = ResourceBundle.getBundle(FILE_NAME);
            for (Column column : columnCollections) {
                String ColumnValue = "";
                boolean skip = false;
                HashMap<String, String> map = column.getColumnAttributesMap();
                try {
                    ColumnValue = rbPaginationConstants.getString(map.get("ColumnName") == null ? "" : map.get("ColumnName").toString());
                }
                catch (Exception ex) {
                    log.error((Object)("Key Not Found" + ex));
                    skip = true;
                }
                if (skip) continue;
                columnDisplayNamesList.add(ColumnValue);
                if (map.get("MethodName") == null) {
                    if (map.get("ParmValue") != null) {
                        columnNamesList.add("paramValue");
                        parameterList.add(map.get("ParmValue").toString());
                    }
                } else {
                    columnNamesList.add(map.get("MethodName").toString());
                    parameterList.add("");
                }
                ++index;
            }
            this.columnDisplayNames = this.populateStringArrays(columnDisplayNamesList);
            this.columnNames = this.populateStringArrays(columnNamesList);
            this.parameterNames = this.populateStringArrays(parameterList);
            ReportWriter.generateReport(response, this.outputType, this.header, this.filterBy, this.sortBy, this.columnDisplayNames, this.columnNames, this.parameterNames, this.records);
        }
        catch (Exception ex) {
            executionStatus = false;
            log.error((Object)("Exception happened while exporting to Excel :" + ex), (Throwable)ex);
        }
        return executionStatus;
    }

    private String[] populateStringArrays(ArrayList arrayList) {
        String[] modifiedString = new String[arrayList.size()];
        int index = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            modifiedString[index] = (String)iterator.next();
            ++index;
        }
        return modifiedString;
    }
}

