/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.web.util.TaskFormParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHelper {
    private static final Logger logger = Logger.getLogger(ProcessHelper.class);
    private static final String TaskInstanceEndedError = "Cannot proceed, current task has already completed.";
    private static final String InvalidTaskInstanceError = "Cannot proceed, current task is invalid.";
    private static final String processFailureError = "Cannot proceed, this work order has already failed. This could be caused by the the time allowed for the current task elapsing.";

    public static TaskInstance setVariables(long processID, long taskInstanceID, Map<String, String> taskVariables, boolean tokenErrorStatusOK) throws Exception {
        TaskInstance taskInstance = ProcessHelper.getActiveTaskInstance(processID, taskInstanceID);
        if (taskInstance == null || taskInstance.hasEnded()) {
            ProcessHelper.handleInvalidTaskInstance(taskInstance, processID, taskInstanceID);
            return null;
        }
        if (!tokenErrorStatusOK && ((CustomToken)taskInstance.getToken()).getStatus() == ProcessStatus.ERROR) {
            throw new Exception(processFailureError);
        }
        ProcessHelper.assignTaskVariables(taskInstance, taskVariables);
        return taskInstance;
    }

    public static void saveProcess(TaskInstance taskInstance) throws Exception {
        WorkflowProcess processInstance = (WorkflowProcess)taskInstance.getContextInstance().getProcessInstance();
        try {
            ServiceRegistry.getDefault().lookup(IPersistenceService.class).save(processInstance);
        }
        catch (DriverRuntimeException e) {
            logger.error((Object)("Failed to save task for process " + processInstance.getId() + " of " + processInstance.getProcessDefinition().getName()), (Throwable)e);
            throw new Exception(e);
        }
    }

    public static TaskInstance getActiveTaskInstance(long processID, long taskInstanceID) throws Exception {
        WorkflowProcess processInstance = ProcessHelper.getProcess(processID);
        Collection ti = processInstance.getTaskMgmtInstance().getTaskInstances();
        logger.debug((Object)("number of tasks:" + ti.size()));
        TaskInstance foundTaskInstance = null;
        for (Object o : ti) {
            TaskInstance taskInstance = (TaskInstance)o;
            logger.debug((Object)("currently checking node:" + taskInstance.getTask().getTaskNode().getName()));
            if (taskInstance.getId() != taskInstanceID || !ProcessHelper.isAnyTokenAtNode(processInstance.getRootToken(), taskInstance.getTask().getTaskNode().getId())) continue;
            logger.debug((Object)("Found task instance " + taskInstance.getId()));
            foundTaskInstance = taskInstance;
            break;
        }
        if (foundTaskInstance == null || foundTaskInstance.hasEnded()) {
            ProcessHelper.handleInvalidTaskInstance(foundTaskInstance, processID, taskInstanceID);
            return null;
        }
        return foundTaskInstance;
    }

    public static List<TaskFormParameter> getTaskInstanceVariables(TaskInstance taskInstance) {
        ArrayList<TaskFormParameter> taskInstanceVariables = new ArrayList<TaskFormParameter>();
        List taskVariables = taskInstance.getTask().getTaskController().getVariableAccesses();
        for (Object obj : taskVariables) {
            VariableAccess variableAccess = (VariableAccess)obj;
            String mappedName = variableAccess.getMappedName();
            Object value = taskInstance.getVariable(mappedName);
            TaskFormParameter taskInstanceVariable = new TaskFormParameter(variableAccess, value);
            taskInstanceVariables.add(taskInstanceVariable);
        }
        return taskInstanceVariables;
    }

    public static String getTemplateNodeID(long processID, long taskInstanceID) {
        WorkflowProcess processInstance = ProcessHelper.getProcess(processID);
        Collection ti = processInstance.getTaskMgmtInstance().getTaskInstances();
        logger.debug((Object)("number of tasks:" + ti.size()));
        TaskInstance foundTaskInstance = null;
        for (Object o : ti) {
            TaskInstance taskInstance = (TaskInstance)o;
            logger.debug((Object)("currently checking node:" + taskInstance.getTask().getTaskNode().getName()));
            if (taskInstance.getId() != taskInstanceID) continue;
            foundTaskInstance = taskInstance;
            break;
        }
        if (foundTaskInstance != null) {
            long templateID = processInstance.getProcessDefinition().getId();
            long nodeID = foundTaskInstance.getTask().getTaskNode().getId();
            return String.valueOf(templateID) + String.valueOf(nodeID);
        }
        return null;
    }

    private static WorkflowProcess getProcess(long processID) {
        return ServiceRegistry.getDefault().lookup(IPersistenceService.class).get(Long.valueOf(processID));
    }

    private static boolean isAnyTokenAtNode(Token token, long nodeID) {
        if (token.getNode().getId() == nodeID) {
            return true;
        }
        for (CustomToken childToken : ((CustomToken)token).getActiveChildTokens()) {
            if (childToken.getNode().getId() != nodeID) continue;
            return true;
        }
        return false;
    }

    private static void assignTaskVariables(TaskInstance taskInstance, Map<String, String> taskVariables) {
        for (Map.Entry<String, String> variablesMapEntry : taskVariables.entrySet()) {
            if (variablesMapEntry.getValue() != null) {
                taskInstance.setVariable(variablesMapEntry.getKey(), (Object)variablesMapEntry.getValue());
                continue;
            }
            logger.warn((Object)("Ignoring: " + variablesMapEntry.getKey() + " from saving to the task as the value is null"));
        }
    }

    private static void handleInvalidTaskInstance(TaskInstance taskInstance, long processID, long taskInstanceID) throws Exception {
        if (taskInstance != null && taskInstance.hasEnded()) {
            throw new Exception("Cannot proceed, current task has already completed. TaskInstanceId:" + taskInstanceID + " Process:" + processID);
        }
        throw new Exception("Cannot proceed, current task is invalid. TaskInstanceId:" + taskInstanceID + " ProcessID:" + processID);
    }
}

