/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.util.CaseInsensitiveComparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jbpm.taskmgmt.def.Task;

public class ProcessInfo {
    private static final Logger logger = Logger.getLogger(ProcessInfo.class);

    public static Map getVariablesToShowInUI(WorkflowProcess process) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new CaseInsensitiveComparator());
        Task startTask = process.getProcessDefinition().getTaskMgmtDefinition().getStartTask();
        List variables = startTask.getTaskController().getVariableAccesses();
        for (int i = 0; i < variables.size(); ++i) {
            TaskVariable taskVar = (TaskVariable)((Object)variables.get(i));
            if (!taskVar.isShowInUI()) continue;
            String variableName = taskVar.getVariableName();
            String variableValue = null;
            if (process.getContextInstance().getVariable(variableName) != null) {
                variableValue = process.getContextInstance().getVariable(variableName).toString();
            }
            logger.debug((Object)("Variable found to show in UI - Tasks Parameters section: " + variableName + " | " + variableValue));
            if (variableValue == null || variableValue.trim().equals("")) continue;
            sortedMap.put(variableName, variableValue);
        }
        return sortedMap;
    }
}

