/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.auth.Credentials;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.RequestProcessor;

public class WFSRequestProcessor
extends RequestProcessor {
    private static final Logger logger = Logger.getLogger(WFSRequestProcessor.class);
    private static final String LOGIN_PATH = "/security/home.do";
    private static final String ACCESS_DENIED_PATH = "unAuthorizedAccess.do?method=unAuthorizedAccess";

    public boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Credentials credentials = (Credentials)session.getAttribute("credentials");
        String url = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null) {
            url = url + "?" + query;
        }
        if (credentials == null) {
            session.invalidate();
            this.getServletContext().setAttribute("SESSION_EXPIRED", (Object)"SESSION_EXPIRED");
            logger.warn((Object)"Session has expired, redirecting to login page");
            if (Boolean.valueOf(request.getParameter("redirect")).booleanValue()) {
                session = request.getSession(true);
                session.setAttribute("redirectUrl", (Object)url);
            }
            try {
                response.sendRedirect(request.getContextPath() + LOGIN_PATH);
            }
            catch (IOException e) {
                logger.error((Object)"Redirection failed", (Throwable)e);
            }
            return false;
        }
        Set<String> actions = credentials.getActions();
        boolean found = false;
        if (url.contains(ACCESS_DENIED_PATH)) {
            return true;
        }
        for (String path : actions) {
            found = found || url.contains(new StringBuffer(path));
        }
        if (!found) {
            try {
                logger.warn((Object)("URL " + url + " access is denied!"));
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/" + ACCESS_DENIED_PATH));
                return false;
            }
            catch (IOException ioException) {
                logger.error((Object)"Forwarding is failed", (Throwable)ioException);
            }
        }
        return true;
    }
}

