/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.auth.ProtectionKey;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.web.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jbpm.graph.def.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkOrderDetails {
    private static final long serialVersionUID = 1L;
    private WorkflowProcess process;
    private String paramValue;
    private ProcessStatus status;

    public WorkOrderDetails(WorkflowProcess workflowProcess) {
        this.process = workflowProcess;
    }

    public WorkOrderDetails(WorkflowProcess process, ProcessStatus status) {
        this.process = process;
        this.status = status;
    }

    public String getParamValue() {
        return (String)this.process.getContextInstance().getVariable(this.paramValue) != null ? (String)this.process.getContextInstance().getVariable(this.paramValue) : "";
    }

    public String getParamValue(String paramValue) {
        return (String)this.process.getContextInstance().getVariable(paramValue) != null ? (String)this.process.getContextInstance().getVariable(paramValue) : "";
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public WorkflowProcess getWorkflowProcess() {
        return this.process;
    }

    public ProcessStatus getAdminStatus() {
        return this.process.getRootToken().getRequestedStatus();
    }

    public String getCurrentTask() {
        Node current = this.process.getRootToken().getNode();
        String name = current.getName();
        if (current.getSuperState() != null) {
            name = current.getSuperState().getName();
        }
        return name;
    }

    public String getEndTime() {
        return CommonUtils.formatTime(this.process.getEnd());
    }

    public ProcessStatus getRunTimeStatus() {
        return this.process.getRootToken().getStatus();
    }

    public String getStartTime() {
        return CommonUtils.formatTime(this.process.getStart());
    }

    public long getWorkOrderNumber() {
        return this.process.getId();
    }

    public String getWorkOrderTemplate() {
        return this.process.getProcessDefinition().getFullName();
    }

    public boolean getFinished() {
        return this.process.hasEnded();
    }

    public String getProtectionKey() {
        String processProtectionKeys = "";
        WorkflowTemplate template = this.process.getProcessDefinition();
        Set<ProtectionKey> protectionKeys = template.getProtectionKeys();
        Iterator<ProtectionKey> i = protectionKeys.iterator();
        while (i.hasNext()) {
            processProtectionKeys = processProtectionKeys + i.next().getName();
            if (!i.hasNext()) continue;
            processProtectionKeys = processProtectionKeys + ", ";
        }
        return processProtectionKeys;
    }

    public Collection<CustomToken> getTokens() {
        if (this.status != null) {
            return this.getFilteredTokens();
        }
        return this.process.getRootToken().getChildTokens();
    }

    public String getExpand() {
        return this.getTokens().size() + " branch(es)";
    }

    private Collection<CustomToken> getFilteredTokens() {
        ArrayList<CustomToken> list = new ArrayList<CustomToken>();
        for (CustomToken token : this.process.getRootToken().getChildTokens()) {
            if ((this.status != ProcessStatus.ACTIVE || token.getStatus() != ProcessStatus.CREATED && token.getStatus() != ProcessStatus.RUNNING && token.getStatus() != ProcessStatus.BUSY) && this.status != token.getStatus()) continue;
            list.add(token);
        }
        return list;
    }
}

