/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.core;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.Processor;
import com.tandbergtv.watchpoint.watchfolder.core.WPFileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryMonitor
extends TimerTask {
    private static final Logger logger = Logger.getLogger(DirectoryMonitor.class);
    private Map<WPFileFilter, List<Processor>> ffProcessorsMap = new HashMap<WPFileFilter, List<Processor>>();
    private Map<WPFileFilter, Map<String, FileInfo>> filesCategorized = new HashMap<WPFileFilter, Map<String, FileInfo>>();
    private boolean firstTime = false;

    protected DirectoryMonitor(Set<WPFileFilter> fileFilters, Processor processor) {
        this.register(fileFilters, processor);
    }

    public void register(WPFileFilter fileFilter, Processor processor) {
        List<Object> processors;
        logger.debug((Object)"Directory Monitor's register(WPFileFilter fileFilter, Processor processor)");
        if (this.ffProcessorsMap.containsKey(fileFilter)) {
            processors = this.ffProcessorsMap.get(fileFilter);
        } else {
            processors = new ArrayList();
            this.ffProcessorsMap.put(fileFilter, processors);
        }
        processors.add(processor);
    }

    public void register(Set<WPFileFilter> fileFilters, Processor processor) {
        logger.debug((Object)"Directory Monitor's register(Set<WPFileFilter> fileFilters, Processor processor)");
        for (WPFileFilter fileFilter : fileFilters) {
            this.register(fileFilter, processor);
        }
    }

    private void findDifference(Map<String, FileInfo> oldFilesMap, Map<String, FileInfo> currFilesMap, Set<FileInfo> createdFiles, Set<FileInfo> deletedFiles, Set<FileInfo> modifiedFiles) {
        logger.debug((Object)"Directory Monitor's findDifference()");
        Set oldFileNamesCopy = (Set)new HashSet<String>(oldFilesMap.keySet()).clone();
        Set currFileNamesCopy = (Set)new HashSet<String>(currFilesMap.keySet()).clone();
        oldFileNamesCopy.removeAll(currFileNamesCopy);
        Set deletedFileNames = oldFileNamesCopy;
        oldFileNamesCopy = (Set)new HashSet<String>(oldFilesMap.keySet()).clone();
        currFileNamesCopy.removeAll(oldFileNamesCopy);
        Set createdFileNames = currFileNamesCopy;
        currFileNamesCopy = (Set)new HashSet<String>(currFilesMap.keySet()).clone();
        oldFileNamesCopy.retainAll(currFileNamesCopy);
        Set retainedFileNames = oldFileNamesCopy;
        logger.debug((Object)("Deleted File Names: " + deletedFileNames));
        logger.debug((Object)("Created File Names: " + createdFileNames));
        logger.debug((Object)("Retained File Names: " + retainedFileNames));
        for (String deletedFileName : deletedFileNames) {
            deletedFiles.add(oldFilesMap.get(deletedFileName));
        }
        for (String createdFileName : createdFileNames) {
            createdFiles.add(currFilesMap.get(createdFileName));
        }
        for (String retainedFileName : retainedFileNames) {
            FileInfo oldFile = oldFilesMap.get(retainedFileName);
            FileInfo currFile = currFilesMap.get(retainedFileName);
            if (currFile.compareTo(oldFile) <= 0) continue;
            modifiedFiles.add(currFile);
        }
    }

    private Map<String, FileInfo> filter(Map<String, FileInfo> files, WPFileFilter fileFilter) {
        logger.debug((Object)"Directory Monitor's filter()");
        HashMap<String, FileInfo> filteredFiles = new HashMap<String, FileInfo>();
        for (String fileName : files.keySet()) {
            if (!fileFilter.accept(fileName)) continue;
            filteredFiles.put(fileName, files.get(fileName));
        }
        return filteredFiles;
    }

    private void notifyProcessors() {
        logger.debug((Object)"Directory Monitor's notifyProcessors()");
        for (List<Processor> processors : this.ffProcessorsMap.values()) {
            for (Processor processor : processors) {
                try {
                    processor.notifyProcessor();
                }
                catch (Throwable t) {
                    logger.error((Object)("Throwable caught while trying to notifyProcessors at the processor: " + processor.getProcessClassName()), t);
                }
            }
        }
    }

    private Map<WPFileFilter, Map<String, FileInfo>> categorize(Map<String, FileInfo> files) {
        logger.debug((Object)"Directory Monitor's categorize()");
        HashMap<WPFileFilter, Map<String, FileInfo>> filesCategorized = new HashMap<WPFileFilter, Map<String, FileInfo>>();
        for (WPFileFilter fileFilter : this.ffProcessorsMap.keySet()) {
            Map<String, FileInfo> filteredFiles = this.filter(files, fileFilter);
            filesCategorized.put(fileFilter, filteredFiles);
        }
        return filesCategorized;
    }

    protected abstract Map<String, FileInfo> getFiles() throws IOException;

    @Override
    public void run() {
        try {
            logger.debug((Object)"Directory Monitor's run()");
            if (this.firstTime) {
                this.filesCategorized = this.categorize(this.getFiles());
                this.firstTime = false;
                return;
            }
            Map<String, FileInfo> currFiles = this.getFiles();
            Map<WPFileFilter, Map<String, FileInfo>> currFilesCategorized = this.categorize(currFiles);
            for (WPFileFilter fileFilter : this.ffProcessorsMap.keySet()) {
                Map<String, FileInfo> currFilesForAFilter;
                logger.debug((Object)fileFilter);
                Map<String, FileInfo> oldFilesForAFilter = this.filesCategorized.get(fileFilter);
                if (oldFilesForAFilter == null) {
                    oldFilesForAFilter = new HashMap<String, FileInfo>();
                }
                if ((currFilesForAFilter = currFilesCategorized.get(fileFilter)) == null) {
                    currFilesForAFilter = new HashMap<String, FileInfo>();
                }
                HashSet<FileInfo> createdFiles = new HashSet<FileInfo>();
                HashSet<FileInfo> deletedFiles = new HashSet<FileInfo>();
                HashSet<FileInfo> modifiedFiles = new HashSet<FileInfo>();
                this.findDifference(oldFilesForAFilter, currFilesForAFilter, createdFiles, deletedFiles, modifiedFiles);
                this.addFiles(this.ffProcessorsMap.get(fileFilter), createdFiles, deletedFiles, modifiedFiles);
            }
            this.notifyProcessors();
            this.filesCategorized = currFilesCategorized;
        }
        catch (Throwable t) {
            logger.error((Object)"Throwable caught in timer run()", t);
        }
    }

    private void addFiles(List<Processor> processors, Set<FileInfo> createdFiles, Set<FileInfo> deletedFiles, Set<FileInfo> modifiedFiles) {
        logger.debug((Object)"Directory Monitor's addFiles()");
        for (Processor processor : processors) {
            processor.addCreatedFiles(createdFiles);
            processor.addDeletedFiles(deletedFiles);
            processor.addModifiedFiles(modifiedFiles);
        }
    }
}

