/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.action;

import com.n2bb.action.AbstractAction;
import com.n2bb.web.util.ListPage;
import com.n2bb.web.util.ListPager;
import com.n2bb.web.util.ReportUtil;
import com.n2bb.web.util.Sort;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class ListPagerAction
extends AbstractAction {
    protected abstract ListPager getListPager(HttpServletRequest var1);

    protected void setAttributes(HttpServletRequest request, ActionErrors errors) {
    }

    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ListPage listPage;
        String sortColumn;
        ActionErrors errors = new ActionErrors();
        boolean exportFlag = false;
        exportFlag = request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export");
        ListPager pager = this.getListPager(request);
        Integer pageSize = this.getInteger(request, "pageSize");
        if (pageSize != null) {
            pager.setPageSize(pageSize);
        }
        if ((sortColumn = request.getParameter("sortColumn")) != null) {
            String sortAscending = request.getParameter("sortAscending");
            Sort sort = new Sort(sortColumn, !sortAscending.trim().equals("false"));
            listPage = pager.getPage(sort);
        } else {
            Integer pageNumber = this.getInteger(request, "pageNumber");
            if (pageNumber == null || pageNumber < 1) {
                pageNumber = new Integer(1);
            }
            listPage = pager.getPage(pageNumber);
        }
        this.setAttributes(request, errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        if (exportFlag) {
            this.exportDataToExcel(request, response, form, pager.getList(), pager);
            return null;
        }
        request.setAttribute("listPager", (Object)pager);
        request.setAttribute("listPage", (Object)listPage);
        return mapping.findForward("success");
    }

    private ActionForward exportDataToExcel(HttpServletRequest request, HttpServletResponse response, ActionForm form, List records, ListPager pager) {
        try {
            String[][] filteredBy = null;
            String[] columnDisplayNames = new String[]{"User Name", "First Name", "Last Name", "Role Name", "Status", "E-Mail"};
            String[] columnNames = new String[]{"userName", "firstName", "lastName", "roleName", "status", "email"};
            String headerName = "Users List";
            String sort = pager.getSortColumn();
            for (int i = 0; i < columnNames.length; ++i) {
                if (!sort.equals(columnNames[i])) continue;
                sort = columnDisplayNames[i];
            }
            String outputType = request.getParameter("outputType");
            if (outputType == null) {
                outputType = "Excel";
            }
            ReportUtil.generateReport(response, outputType, headerName, filteredBy, sort, columnDisplayNames, columnNames, records);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

