/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.realm;

import com.n2bb.util.PropertyManager;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.catalina.Realm;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.DataSourceRealm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class N2bbDataSourceRealm
extends DataSourceRealm {
    private static Log authLog = LogFactory.getLog((String)"authLog");
    private static Hashtable lockHash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, String credentials) {
        authLog.debug((Object)"enter");
        Connection dbConnection = this.open();
        try {
            Principal principal = super.authenticate(username, credentials);
            if (principal == null) {
                this.handleInvalidLogin(username, dbConnection);
            } else {
                authLog.info((Object)("Got valid password for username... " + username));
                lockHash.remove(username);
                if (this.isInactive(username, dbConnection)) {
                    authLog.warn((Object)("Unfortunately, username " + username + " is inactive.  " + "Login denied."));
                    Principal principal2 = null;
                    return principal2;
                }
                if (this.isPasswordExpired(dbConnection, username)) {
                    principal = new GenericPrincipal((Realm)this, "chpass_" + username, "", Arrays.asList("chpass"));
                }
            }
            Principal principal3 = principal;
            return principal3;
        }
        catch (SQLException e) {
            Principal principal = null;
            return principal;
        }
        finally {
            this.close(dbConnection);
        }
    }

    private void handleInvalidLogin(String username, Connection dbConnection) throws SQLException {
        authLog.warn((Object)("login FAILED for user name... " + username));
        if (!"admin".equals(username)) {
            LoginBean lb = (LoginBean)lockHash.get(username);
            if (lb == null) {
                authLog.debug((Object)("adding first attempt for user name... " + username));
                lb = new LoginBean(System.currentTimeMillis());
                lockHash.put(username, lb);
            } else if (lb.getAttemptsWithinTimePeriod(System.currentTimeMillis() - 300000L) >= 2) {
                authLog.warn((Object)("setting user name inactive... " + username));
                lockHash.remove(username);
                this.setInactive(dbConnection, username);
            } else {
                authLog.debug((Object)("adding attempt for user name... " + username));
                lb.addAttempt(System.currentTimeMillis());
            }
        }
    }

    protected synchronized boolean isPasswordExpired(Connection dbConnection, String username) throws SQLException {
        int passwordLifeInDays = this.getPasswordLife();
        if (passwordLifeInDays <= 0) {
            return false;
        }
        Timestamp passwordModifiedDate = this.getPasswordModifiedDate(dbConnection, username);
        if (passwordModifiedDate == null) {
            return true;
        }
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.setTime(passwordModifiedDate);
        expirationDate.add(6, passwordLifeInDays);
        return new Date().after(expirationDate.getTime());
    }

    private int getPasswordLife() {
        return PropertyManager.getInstance().getInteger("PASSWORD_LIFE", 0);
    }

    private void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getPasswordModifiedDate(Connection dbConnection, String username) {
        String sql = "select PASSWORD_MODIFIED_DATE  from " + this.userTable + " where " + this.userNameCol + " = ?";
        PreparedStatement pstmt = null;
        Timestamp passwordModifiedDate = null;
        try {
            pstmt = dbConnection.prepareStatement(sql);
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            passwordModifiedDate = null;
            if (rs.next()) {
                passwordModifiedDate = rs.getTimestamp(1);
            }
        }
        catch (SQLException e) {
            authLog.error((Object)("Unable to get password modified date for " + username), (Throwable)e);
        }
        finally {
            this.closeStatement(pstmt);
        }
        return passwordModifiedDate;
    }

    protected boolean isInactive(String username, Connection dbConnection) throws SQLException {
        authLog.debug((Object)("enter user name... " + username));
        PreparedStatement pstmt = dbConnection.prepareStatement("select status from " + this.userTable + " where " + this.userNameCol + " = ?");
        pstmt.setString(1, username);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            return rs.getInt(1) == 0;
        }
        authLog.warn((Object)"isInactive failed to find user.  Shouldn't happen!");
        return true;
    }

    protected synchronized void setInactive(Connection dbConnection, String username) throws SQLException {
        authLog.debug((Object)("enter user name... " + username));
        PreparedStatement stmt = dbConnection.prepareStatement("UPDATE " + this.userTable + " set status=0 " + " WHERE " + this.userNameCol + " = ?");
        stmt.setString(1, username);
        stmt.executeUpdate();
        authLog.debug((Object)"leave");
    }

    protected Connection open() {
        try {
            StandardServer server = (StandardServer)ServerFactory.getServer();
            InitialContext context = new InitialContext();
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            dbConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    class LoginBean {
        private long[] times = new long[4];
        private int attempts = 0;

        public LoginBean(long attemptTime) {
            this.addAttempt(attemptTime);
        }

        public synchronized void addAttempt(long attemptTime) {
            this.times[this.attempts++] = attemptTime;
        }

        public synchronized int getAttemptsWithinTimePeriod(long timePeriod) {
            int i;
            authLog.debug((Object)("enter total attempts... " + this.attempts));
            authLog.debug((Object)("enter timePeriod... " + timePeriod));
            for (int i2 = 0; i2 < this.times.length; ++i2) {
                authLog.debug((Object)("enter times " + this.times[i2]));
            }
            int attemptsInPeriod = 0;
            for (i = this.attempts - 1; i >= 0; --i) {
                if (this.times[i] >= timePeriod) {
                    authLog.debug((Object)("attempt found within time period at pos... " + attemptsInPeriod));
                    ++attemptsInPeriod;
                    continue;
                }
                int inPeriodAttempts = i + 1;
                int k = 0;
                for (int j = inPeriodAttempts; j < this.times.length; ++j) {
                    this.times[k++] = this.times[j];
                }
                this.attempts = attemptsInPeriod;
                break;
            }
            for (i = 0; i < this.times.length; ++i) {
                authLog.debug((Object)("leave times " + this.times[i]));
            }
            authLog.debug((Object)("attemptsInPeriod... " + attemptsInPeriod));
            return attemptsInPeriod;
        }
    }
}

