/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.alerts;

import com.n2bb.util.N2bbEmail;
import com.n2bb.util.N2bbException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public final class AlertForm
extends ActionForm {
    private static Log n2bbLog = LogFactory.getLog(AlertForm.class);
    private String action = "add";
    private String alertIdentifier = null;
    private String alertPattern = null;
    private String thresholdCount = null;
    private String thresholdHr = null;
    private String thresholdMin = null;
    private String thresholdSec = null;
    private String frequencyCount = null;
    private String frequencyHr = null;
    private String frequencyMin = null;
    private String frequencySec = null;
    private boolean chkEmail = false;
    private String txtEmail = null;
    private boolean chkSnmp = false;
    private String txtSnmp = null;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        try {
            int count;
            int count2;
            if (this.getAlertIdentifier().equals("")) {
                errors.add("alertIdentifier", new ActionError("error.alert.idRequired"));
            }
            if (this.getAlertIdentifier().length() > 32) {
                errors.add("alertIdentifier", new ActionError("error.alert.idTooLong"));
            }
            if (this.getAlertPattern().equals("")) {
                errors.add("alertPattern", new ActionError("error.alert.patternRequired"));
            }
            if (this.getThresholdCount().equals("")) {
                errors.add("threshold", new ActionError("error.alert.thresholdCountReq"));
            } else {
                try {
                    int count3 = Integer.parseInt(this.getThresholdCount());
                    if (count3 < 1 || count3 > 999) {
                        errors.add("threshold", new ActionError("error.alert.thresholdCountRange"));
                    }
                }
                catch (Exception e) {
                    errors.add("threshold", new ActionError("error.alert.thresholdCountRange"));
                }
            }
            int totalThresholdTime = 0;
            if (!this.getThresholdHr().trim().equals("")) {
                try {
                    count2 = Integer.parseInt(this.getThresholdHr());
                    if (count2 < 0 || count2 > 999) {
                        errors.add("threshold", new ActionError("error.alert.thresholdHrRange"));
                    } else {
                        totalThresholdTime += count2;
                    }
                }
                catch (Exception e) {
                    errors.add("threshold", new ActionError("error.alert.thresholdHrRange"));
                }
            }
            if (!this.getThresholdMin().trim().equals("")) {
                try {
                    count2 = Integer.parseInt(this.getThresholdMin());
                    if (count2 < 0 || count2 > 59) {
                        errors.add("threshold", new ActionError("error.alert.thresholdMinRange"));
                    } else {
                        totalThresholdTime += count2;
                    }
                }
                catch (Exception e) {
                    errors.add("threshold", new ActionError("error.alert.thresholdMinRange"));
                }
            }
            if (!this.getThresholdSec().trim().equals("")) {
                try {
                    int count4 = Integer.parseInt(this.getThresholdSec());
                    if (count4 < 0 || count4 > 59) {
                        errors.add("threshold", new ActionError("error.alert.thresholdSecRange"));
                    } else {
                        totalThresholdTime += count4;
                    }
                }
                catch (Exception e) {
                    errors.add("threshold", new ActionError("error.alert.thresholdSecRange"));
                }
            }
            if (totalThresholdTime < 1 || this.getThresholdSec().trim().equals("") && this.getThresholdMin().trim().equals("") && this.getThresholdHr().trim().equals("")) {
                errors.add("threshold", new ActionError("error.alert.thresholdTotTime"));
            }
            if (this.getFrequencyCount().equals("")) {
                errors.add("frequency", new ActionError("error.alert.frequencyCountReq"));
            } else {
                try {
                    int count5 = Integer.parseInt(this.getFrequencyCount());
                    if (count5 < 1 || count5 > 999) {
                        errors.add("frequency", new ActionError("error.alert.frequencyCountRange"));
                    }
                }
                catch (Exception e) {
                    errors.add("frequency", new ActionError("error.alert.frequencyCountRange"));
                }
            }
            int totalFrequencyTime = 0;
            if (!this.getFrequencyHr().trim().equals("")) {
                try {
                    count = Integer.parseInt(this.getFrequencyHr());
                    if (count < 0 || count > 999) {
                        errors.add("frequency", new ActionError("error.alert.frequencyHrRange"));
                    } else {
                        totalFrequencyTime += count;
                    }
                }
                catch (Exception e) {
                    errors.add("frequency", new ActionError("error.alert.frequencyHrRange"));
                }
            }
            if (!this.getFrequencyMin().trim().equals("")) {
                try {
                    count = Integer.parseInt(this.getFrequencyMin());
                    if (count < 0 || count > 59) {
                        errors.add("frequency", new ActionError("error.alert.frequencyMinRange"));
                    } else {
                        totalFrequencyTime += count;
                    }
                }
                catch (Exception e) {
                    errors.add("frequency", new ActionError("error.alert.frequencyMinRange"));
                }
            }
            if (!this.getFrequencySec().trim().equals("")) {
                try {
                    int count6 = Integer.parseInt(this.getFrequencySec());
                    if (count6 < 0 || count6 > 59) {
                        errors.add("frequency", new ActionError("error.alert.frequencySecRange"));
                    } else {
                        totalFrequencyTime += count6;
                    }
                }
                catch (Exception e) {
                    errors.add("frequency", new ActionError("error.alert.frequencySecRange"));
                }
            }
            if (this.getChkEmail() && this.getTxtEmail().equals("")) {
                errors.add("alertActions", new ActionError("error.alert.emailChecked"));
            } else if (this.getChkEmail()) {
                n2bbLog.debug((Object)("email... '" + this.getTxtEmail() + "'"));
                try {
                    N2bbEmail email = new N2bbEmail(this.getTxtEmail());
                }
                catch (N2bbException e) {
                    n2bbLog.debug((Object)("email n2bb exception - message... " + e.getMessage()));
                    errors.add("alertActions", new ActionError(e.getErrorCode()));
                }
                catch (Exception e) {
                    n2bbLog.error((Object)("email exception - message... " + e.getMessage()), (Throwable)e);
                    errors.add("alertActions", new ActionError("error.email.validationFailed"));
                }
            }
            if (this.getChkSnmp() && this.getTxtSnmp().equals("")) {
                errors.add("alertActions", new ActionError("error.alert.snmpChecked"));
            }
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other.validation"));
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
        }
        return errors;
    }

    public String getAlertIdentifier() {
        return this.alertIdentifier == null ? "" : this.alertIdentifier;
    }

    public String getAlertPattern() {
        return this.alertPattern == null ? "" : this.alertPattern;
    }

    public String getThresholdCount() {
        return this.thresholdCount == null ? "" : this.thresholdCount;
    }

    public String getThresholdHr() {
        return this.thresholdHr == null ? "" : this.thresholdHr;
    }

    public String getThresholdMin() {
        return this.thresholdMin == null ? "" : this.thresholdMin;
    }

    public String getThresholdSec() {
        return this.thresholdSec == null ? "" : this.thresholdSec;
    }

    public String getFrequencyCount() {
        return this.frequencyCount == null ? "" : this.frequencyCount;
    }

    public String getFrequencyHr() {
        return this.frequencyHr == null ? "" : this.frequencyHr;
    }

    public String getFrequencyMin() {
        return this.frequencyMin == null ? "" : this.frequencyMin;
    }

    public String getFrequencySec() {
        return this.frequencySec == null ? "" : this.frequencySec;
    }

    public boolean getChkEmail() {
        return this.chkEmail;
    }

    public String getTxtEmail() {
        return this.txtEmail == null ? "" : this.txtEmail;
    }

    public boolean getChkSnmp() {
        return this.chkSnmp;
    }

    public String getTxtSnmp() {
        return this.txtSnmp == null ? "" : this.txtSnmp;
    }

    public void setAlertIdentifier(String alertIdentifier) {
        this.alertIdentifier = alertIdentifier.trim();
    }

    public void setAlertPattern(String alertPattern) {
        this.alertPattern = alertPattern;
    }

    public void setThresholdCount(String thresholdCount) {
        this.thresholdCount = thresholdCount;
    }

    public void setThresholdHr(String thresholdHr) {
        this.thresholdHr = thresholdHr;
    }

    public void setThresholdMin(String thresholdMin) {
        this.thresholdMin = thresholdMin;
    }

    public void setThresholdSec(String thresholdSec) {
        this.thresholdSec = thresholdSec;
    }

    public void setFrequencyCount(String frequencyCount) {
        this.frequencyCount = frequencyCount;
    }

    public void setFrequencyHr(String frequencyHr) {
        this.frequencyHr = frequencyHr;
    }

    public void setFrequencyMin(String frequencyMin) {
        this.frequencyMin = frequencyMin;
    }

    public void setFrequencySec(String frequencySec) {
        this.frequencySec = frequencySec;
    }

    public void setChkEmail(boolean chkEmail) {
        this.chkEmail = chkEmail;
    }

    public void setTxtEmail(String txtEmail) {
        this.txtEmail = txtEmail;
    }

    public void setChkSnmp(boolean chkSnmp) {
        this.chkSnmp = chkSnmp;
    }

    public void setTxtSnmp(String txtSnmp) {
        this.txtSnmp = txtSnmp;
    }
}

