/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.alerts;

import com.n2bb.action.AbstractAction;
import com.n2bb.sysmonui.alerts.AlertListPager;
import com.n2bb.sysmonui.alerts.ListAlertsAction;
import com.n2bb.web.util.ListPage;
import com.n2bb.web.util.ListPager;
import com.n2bb.web.util.ReportUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ReportAlertsAction
extends AbstractAction {
    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ListPager pager = ListAlertsAction.getAlertListPager(request);
            if (pager == null) {
                log.error((Object)"no pager in session");
                pager = new AlertListPager();
            }
            pager.setShowWholeList(true);
            ListPage page = pager.getPage(1);
            List alerts = page.getPageData();
            pager.setShowWholeList(false);
            String[][] filteredBy = null;
            String[] columnDisplayNames = new String[]{"Alert Identifier", "Alert Pattern", "Threshold", "Frequency", "Email", "SNMP"};
            String[] columnNames = new String[]{"alertIdentifier", "alertPattern", "formattedThreshold", "formattedFrequency", "email", "sNMP"};
            String headerName = "List Alerts";
            String sort = pager.getSortColumn();
            for (int i = 0; i < columnNames.length; ++i) {
                if (!sort.equals(columnNames[i])) continue;
                sort = columnDisplayNames[i];
            }
            String outputType = request.getParameter("outputType");
            if (outputType == null) {
                outputType = "Excel";
            }
            ReportUtil.generateReport(response, outputType, headerName, filteredBy, sort, columnDisplayNames, columnNames, alerts);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

