/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.availability;

import com.n2bb.sysmonui.availability.HostBean;
import com.n2bb.sysmonui.availability.ServerBean;
import com.n2bb.util.N2bbException;
import com.n2bb.web.util.ListPage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AvailabilityFacade {
    private static final Log log = LogFactory.getLog((String)"n2bbLog");
    private static AvailabilityFacade instance;

    private AvailabilityFacade() {
    }

    public static synchronized AvailabilityFacade getInstance() {
        if (instance == null) {
            instance = new AvailabilityFacade();
        }
        return instance;
    }

    public ListPage getServerPage(int pageNumber) throws N2bbException {
        return new ListPage(this.getServerList(), 1, 1);
    }

    private List getServerList() throws N2bbException {
        ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
        Document statusXML = this.getStatusXMLDocument();
        Element root = statusXML.getDocumentElement();
        NodeList videos = root.getElementsByTagName("Server");
        for (int i = 0; i < videos.getLength(); ++i) {
            Element server = (Element)videos.item(i);
            servers.add(new ServerBean(server.getAttribute("name"), server.getAttribute("curHost"), Integer.parseInt(server.getAttribute("opState")), Integer.parseInt(server.getAttribute("reqState")), server.getAttribute("startOid"), server.getAttribute("endOid")));
        }
        Collections.sort(servers, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ServerBean)o1).getName().compareTo(((ServerBean)o2).getName());
            }
        });
        return servers;
    }

    public void requestServerState(String name, int newReqState) throws N2bbException {
        try {
            String urlString = "http://availmgr:8001/get?method=setRequestedState&checkName=" + URLEncoder.encode(name, "UTF-8") + "&requestedState=" + newReqState;
            this.getURLContent(urlString);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"", (Throwable)e);
            throw new N2bbException("error.unexpected", e.getMessage());
        }
    }

    public ServerBean getServer(String name) throws N2bbException {
        return this.findServer(this.getServerList(), name);
    }

    private ServerBean findServer(List servers, String name) {
        for (ServerBean serverBean : servers) {
            if (!serverBean.getName().equals(name)) continue;
            return serverBean;
        }
        return null;
    }

    public void moveServer(String name, String newHost) throws N2bbException {
        try {
            String urlString = "http://availmgr:8001/get?method=moveServer&checkName=" + URLEncoder.encode(name, "UTF-8") + "&hostName=" + URLEncoder.encode(newHost, "UTF-8");
            this.getURLContent(urlString);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"", (Throwable)e);
            throw new N2bbException("error.unexpected", e.getMessage());
        }
    }

    public List getAvailableHosts(ServerBean server) throws N2bbException {
        ArrayList hosts = new ArrayList(this.getHosts());
        Iterator iterator = hosts.iterator();
        while (iterator.hasNext()) {
            HostBean hostBean = (HostBean)iterator.next();
            if (!hostBean.getName().equals(server.getHostName())) continue;
            iterator.remove();
        }
        Collections.sort(hosts, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((HostBean)o1).getName().compareTo(((HostBean)o2).getName());
            }
        });
        return hosts;
    }

    public List getHosts() throws N2bbException {
        List hosts = this.getHostList();
        return hosts;
    }

    private List getHostList() throws N2bbException {
        ArrayList<HostBean> hosts = new ArrayList<HostBean>();
        Document statusXML = this.getStatusXMLDocument();
        Element root = statusXML.getDocumentElement();
        NodeList videos = root.getElementsByTagName("Host");
        for (int i = 0; i < videos.getLength(); ++i) {
            Element server = (Element)videos.item(i);
            hosts.add(new HostBean(server.getAttribute("name"), server.getAttribute("startOid"), server.getAttribute("endOid"), Integer.parseInt(server.getAttribute("opState"))));
        }
        return hosts;
    }

    private Document getStatusXMLDocument() throws N2bbException {
        try {
            return AvailabilityFacade.getXMLDocument(this.getURLContent("http://availmgr:8001/get?method=getStatusUI"));
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"", (Throwable)e);
            throw new N2bbException("sysmonui.error.status.xml");
        }
        catch (SAXException e) {
            log.error((Object)"", (Throwable)e);
            throw new N2bbException("sysmonui.error.status.xml");
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new N2bbException("sysmonui.error.status.io");
        }
    }

    private String getURLContent(String urlString) {
        String response = "";
        try {
            URL url = new URL(urlString);
            Object content = url.getContent();
            if (content instanceof InputStream) {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)content));
                while ((s = reader.readLine()) != null) {
                    response = response + s;
                }
                response = response.trim();
                log.debug((Object)("response = " + response));
            } else {
                log.error((Object)("Got unknown URL content type: " + content.getClass()));
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return response;
    }

    private static Document getXMLDocument(InputStream xml) throws ParserConfigurationException, SAXException, IOException {
        return AvailabilityFacade.getDocumentBuilder().parse(xml);
    }

    private static Document getXMLDocument(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return AvailabilityFacade.getXMLDocument(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }
}

