/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.user;

import com.n2bb.action.N2bbAction;
import com.n2bb.security.SecurityManager;
import com.n2bb.user.UserBean;
import com.n2bb.user.UserForm;
import com.n2bb.user.UserManager;
import com.n2bb.util.N2bbException;
import com.tandbergtv.workflow.auth.ACLEntry;
import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.Role;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class UserAction
extends N2bbAction {
    private UserManager getUserManager() {
        return UserManager.getInstance();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defaultAction = "add";
        HttpSession session = request.getSession();
        String action = request.getParameter("actionType");
        if (request.getAttribute("actionType") != null) {
            action = (String)request.getAttribute("actionType");
        }
        if (action == null || action.equals("")) {
            action = defaultAction;
        }
        this.n2bbLog.debug((Object)("action... " + action));
        ActionErrors errors = new ActionErrors();
        ActionForward fwd = new ActionForward("home");
        try {
            UserForm uf = (UserForm)form;
            if (action.equals("add")) {
                fwd = this.addUser(errors, session) ? mapping.findForward("success") : mapping.findForward("failure");
            } else if (action.equals("save")) {
                if (this.saveUser(errors, uf)) {
                    request.setAttribute("save", (Object)"save");
                    fwd = mapping.findForward("success");
                    this.n2bbLog.debug((Object)("The path--->" + fwd));
                } else {
                    fwd = mapping.findForward("failure");
                }
            } else if (action.equals("edit")) {
                if (this.editUser(errors, session, request)) {
                    request.setAttribute("TabbedModify", (Object)"TabbedModify");
                    fwd = mapping.findForward("success");
                } else {
                    fwd = mapping.findForward("failure");
                }
            } else if (action.equals("update")) {
                if (this.updateUser(errors, uf)) {
                    request.setAttribute("update", (Object)"update");
                    fwd = mapping.findForward("success");
                } else {
                    fwd = mapping.findForward("failure");
                }
            }
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return fwd;
    }

    private boolean addUser(ActionErrors errors, HttpSession session) {
        this.n2bbLog.debug((Object)"enter");
        try {
            Hashtable<String, Vector> userHash = (Hashtable<String, Vector>)session.getAttribute("userHash");
            if (userHash == null) {
                userHash = new Hashtable<String, Vector>();
            }
            Vector n2RoleVector = new Vector();
            try {
                n2RoleVector = SecurityManager.getInstance().getRoleNames();
            }
            catch (N2bbException e) {
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.n2Roles"));
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
                this.n2bbLog.error((Object)("failed to get role names exception - message... " + e.getMessage()), (Throwable)e);
            }
            userHash.put("n2RoleVector", n2RoleVector);
            session.setAttribute("userHash", userHash);
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.add"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean saveUser(ActionErrors errors, UserForm form) {
        this.n2bbLog.debug((Object)"enter");
        try {
            try {
                UserBean bean = this.convertFormToBean(form);
                this.getUserManager().saveUser(bean);
            }
            catch (N2bbException e) {
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.save"));
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
                this.n2bbLog.error((Object)("failed to save - message... " + e.getMessage()), (Throwable)e);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.save"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean editUser(ActionErrors errors, HttpSession session, HttpServletRequest request) {
        this.n2bbLog.debug((Object)"enter");
        try {
            Hashtable<String, Vector> userHash = (Hashtable<String, Vector>)session.getAttribute("userHash");
            if (userHash == null) {
                userHash = new Hashtable<String, Vector>();
            }
            Vector n2RoleVector = new Vector();
            try {
                n2RoleVector = SecurityManager.getInstance().getRoleNames();
            }
            catch (N2bbException e) {
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.n2Roles"));
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
                this.n2bbLog.error((Object)("failed to get role names exception - message... " + e.getMessage()), (Throwable)e);
            }
            userHash.put("n2RoleVector", n2RoleVector);
            session.setAttribute("userHash", userHash);
            try {
                String userName = request.getParameter("userName");
                UserBean bean = this.getUserManager().getUser(userName);
                UserForm form = this.convertBeanToForm(bean);
                form.setActionType("edit");
                request.setAttribute("userForm", (Object)form);
            }
            catch (N2bbException e) {
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.edit"));
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
                this.n2bbLog.error((Object)("failed to get user exception - message... " + e.getMessage()), (Throwable)e);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.edit"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean updateUser(ActionErrors errors, UserForm form) {
        this.n2bbLog.debug((Object)"enter");
        try {
            UserBean bean = this.convertFormToBean(form);
            ResourceManagement resourceManager = ResourceManager.getInstance();
            try {
                IAuthorizationManager authorizationManager = AuthorizationManager.getInstance();
                boolean isResourceExists = false;
                if (resourceManager.getResourceByUser(form.getUserName()) != null) {
                    isResourceExists = true;
                }
                if (isResourceExists) {
                    Role role = authorizationManager.getRole((Serializable)((Object)form.getRoleName()));
                    Set<ACLEntry> setACLEntries = role.getACL();
                    long performTaskId = 0L;
                    for (ACLEntry entry : setACLEntries) {
                        if (!entry.getPermission().getName().equalsIgnoreCase("Perform Task")) continue;
                        performTaskId = entry.getPermission().getId();
                        break;
                    }
                    if (performTaskId == 0L) {
                        throw new N2bbException("error.userAction.userRoleChangeNotAllowed");
                    }
                }
                this.getUserManager().updateUser(bean, form.getChangePassword());
            }
            catch (N2bbException e) {
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.update"));
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
                this.n2bbLog.error((Object)("failed to update - message... " + e.getMessage()), (Throwable)e);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.userAction.update"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private UserBean convertFormToBean(UserForm form) {
        UserBean bean = new UserBean();
        bean.setUserName(form.getUserName());
        bean.setPassword(form.getPassword());
        bean.setFirstName(form.getFirstName());
        bean.setLastName(form.getLastName());
        bean.setRoleName(form.getRoleName());
        bean.setStatus(form.getStatus());
        bean.setEmail(form.getEmail());
        bean.setPhone(form.getPhoneArea() + form.getPhoneFirst() + form.getPhoneLast());
        bean.setExtn(form.getExtn());
        bean.setEmployeeId(form.getEmployeeId());
        bean.setDepartment(form.getDepartment());
        bean.setLocation(form.getLocation());
        return bean;
    }

    private UserForm convertBeanToForm(UserBean bean) {
        UserForm form = new UserForm();
        form.setUserName(bean.getUserName());
        form.setPassword(bean.getPassword());
        form.setConfirmPassword(bean.getPassword());
        form.setFirstName(bean.getFirstName());
        form.setLastName(bean.getLastName());
        form.setRoleName(bean.getRoleName());
        form.setStatus(bean.getStatus());
        form.setEmail(bean.getEmail());
        String phone = bean.getPhone();
        if (phone.length() >= 3) {
            form.setPhoneArea(phone.substring(0, 3));
        }
        if (phone.length() >= 6) {
            form.setPhoneFirst(phone.substring(3, 6));
        }
        if (phone.length() >= 10) {
            form.setPhoneLast(phone.substring(6, 10));
        }
        form.setExtn(bean.getExtn());
        form.setEmployeeId(bean.getEmployeeId());
        form.setDepartment(bean.getDepartment());
        form.setLocation(bean.getLocation());
        return form;
    }
}

