/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortCriteria
implements Comparator {
    private static Log n2bbLog = LogFactory.getLog((String)"n2bbLog");
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private String primaryMethodCriteria;
    private String primaryMethodReturnType;
    private int primaryOrderCriteria = 1;
    private String secondaryMethodCriteria;
    private String secondaryMethodReturnType;
    private int secondaryOrderCriteria = 1;

    public void setPrimaryMethodCriteria(String primaryMethodCriteria) {
        this.primaryMethodCriteria = primaryMethodCriteria;
    }

    public void setPrimaryMethodReturnType(String primaryMethodReturnType) {
        this.primaryMethodReturnType = primaryMethodReturnType;
    }

    public void setPrimaryOrderCriteria(int primaryOrderCriteria) {
        this.primaryOrderCriteria = primaryOrderCriteria;
    }

    public void setSecondaryMethodCriteria(String secondaryMethodCriteria) {
        this.secondaryMethodCriteria = secondaryMethodCriteria;
    }

    public void setSecondaryMethodReturnType(String secondaryMethodReturnType) {
        this.secondaryMethodReturnType = secondaryMethodReturnType;
    }

    public void setSecondaryOrderCriteria(int secondaryOrderCriteria) {
        this.secondaryOrderCriteria = secondaryOrderCriteria;
    }

    public int compare(Object obj1, Object obj2) {
        int result = this.compareObjects(obj1, obj2, 1);
        if (result == 0 && this.secondaryMethodCriteria != null) {
            return this.compareObjects(obj1, obj2, 2);
        }
        return result;
    }

    private int compareObjects(Object obj1, Object obj2, int which) {
        try {
            Collator collator = Collator.getInstance(Locale.US);
            int returnValue = 0;
            String methodName = "";
            String returnType = "";
            int orderCriteria = 1;
            if (which == 1) {
                methodName = this.primaryMethodCriteria;
                returnType = this.primaryMethodReturnType;
                orderCriteria = this.primaryOrderCriteria;
            } else {
                methodName = this.secondaryMethodCriteria;
                returnType = this.secondaryMethodReturnType;
                orderCriteria = this.secondaryOrderCriteria;
            }
            Method method = obj1.getClass().getMethod(methodName, null);
            if (returnType == null) {
                returnType = "" + method.getReturnType();
            }
            if (returnType.indexOf("String") >= 0) {
                String s1 = ((String)method.invoke(obj1, null)).toLowerCase();
                String s2 = ((String)method.invoke(obj2, null)).toLowerCase();
                returnValue = collator.compare(s1, s2);
            } else if (returnType.indexOf("Date") >= 0) {
                Date d1 = (Date)method.invoke(obj1, null);
                Date d2 = (Date)method.invoke(obj2, null);
                returnValue = this.compareDateObjects(d1, d2);
            } else if (returnType.indexOf("int") >= 0 || returnType.indexOf("Integer") >= 0) {
                int i2;
                int i1 = (Integer)method.invoke(obj1, null);
                if (i1 > (i2 = ((Integer)method.invoke(obj2, null)).intValue())) {
                    returnValue = 1;
                } else if (i2 > i1) {
                    returnValue = -1;
                }
            } else if (returnType.toLowerCase().indexOf("short") >= 0) {
                returnValue = ((Short)method.invoke(obj1, null)).compareTo((Short)method.invoke(obj2, null));
            } else if (returnType.indexOf("long") >= 0 || returnType.indexOf("Long") >= 0) {
                long l2;
                long l1 = (Long)method.invoke(obj1, null);
                if (l1 > (l2 = ((Long)method.invoke(obj2, null)).longValue())) {
                    returnValue = 1;
                } else if (l2 > l1) {
                    returnValue = -1;
                }
            } else if (returnType.indexOf("double") >= 0 || returnType.indexOf("Double") >= 0) {
                double d2;
                double d1 = (Double)method.invoke(obj1, null);
                if (d1 > (d2 = ((Double)method.invoke(obj2, null)).doubleValue())) {
                    returnValue = 1;
                } else if (d2 > d1) {
                    returnValue = -1;
                }
            } else {
                try {
                    Object compareThis = method.invoke(obj1, null);
                    Object compareTo = method.invoke(obj2, null);
                    if (compareThis instanceof Comparable && compareTo instanceof Comparable) {
                        returnValue = ((Comparable)compareThis).compareTo(compareTo);
                    }
                }
                catch (Exception e) {
                    returnValue = 0;
                }
            }
            if (orderCriteria == 2) {
                return -returnValue;
            }
            return returnValue;
        }
        catch (Exception e) {
            n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            return -1;
        }
    }

    public int compareDateObjects(Date date1, Date date2) {
        if (date1.before(date2)) {
            return 1;
        }
        if (date1.after(date2)) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public static SortCriteria create(String primaryMethod, boolean ascending) {
        String methodName = "get" + Character.toUpperCase(primaryMethod.charAt(0)) + primaryMethod.substring(1);
        SortCriteria sorting = new SortCriteria();
        sorting.setPrimaryMethodCriteria(methodName);
        sorting.setPrimaryOrderCriteria(ascending ? 1 : 2);
        return sorting;
    }

    public static SortCriteria create(String primaryMethod, String secondaryMethod, boolean ascending) {
        String methodName1 = "get" + Character.toUpperCase(primaryMethod.charAt(0)) + primaryMethod.substring(1);
        String methodName2 = "get" + Character.toUpperCase(secondaryMethod.charAt(0)) + secondaryMethod.substring(1);
        SortCriteria sorting = new SortCriteria();
        sorting.setPrimaryMethodCriteria(methodName1);
        sorting.setSecondaryMethodCriteria(methodName2);
        sorting.setPrimaryOrderCriteria(ascending ? 1 : 2);
        return sorting;
    }
}

